% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PC.Mk.II.Full.Details.R
\name{pcFullDetails}
\alias{pcFullDetails}
\title{Pattern Causality Mark II: Full Details}
\usage{
pcFullDetails(X, Y, E, tau, metric, h, weighted)
}
\arguments{
\item{X}{Numeric vector, the first time series data.}

\item{Y}{Numeric vector, the second time series data.}

\item{E}{Integer, the embedding dimension used in the reconstruction of the state space.}

\item{tau}{Integer, the time delay between data points in the reconstruction.}

\item{metric}{Character, the distance metric used (e.g., 'euclidean', 'manhattan').}

\item{h}{Integer, the prediction horizon, specifying the number of steps ahead for causality analysis.}

\item{weighted}{Logical, specifies if causality strength should be weighted.}
}
\value{
A list containing various outputs including matrices of nearest neighbors, predicted and actual causality matrices, signature matrices, pattern vectors, and diagnostics related to the time series analysis and causality assessment.
}
\description{
Implements an advanced pattern causality algorithm to explore the causal relationships between two time series datasets. This function reconstructs state spaces, calculates distances, and evaluates causality using predefined metrics and pattern analysis. The methodology supports complex system analysis where traditional linear methods fall short.
}
\examples{
data(climate_indices)
X <- climate_indices$AO
Y <- climate_indices$AAO
result <- pcFullDetails(X, Y, E = 3, tau = 2, metric = "euclidean", h = 1, weighted = TRUE)
print(result)
}
