% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opal.sql.R
\name{opal.sql_history}
\alias{opal.sql_history}
\title{SQL query execution history}
\usage{
opal.sql_history(
  opal,
  project = NULL,
  offset = 0,
  limit = 100,
  user = NULL,
  df = TRUE
)
}
\arguments{
\item{opal}{Opal connection object.}

\item{project}{Project name used as the SQL execution context, to filter. If not specified, history from any context 
is returned. If NA is specified, the history of SQL executions without context is returned. Default is NULL.}

\item{offset}{Number of history items to skip. Default is 0 (note that the items are ordered by most recent first).}

\item{limit}{Maximum number of history items to return. Default is 100.}

\item{user}{Filter by user name, only administrators can retrieve SQL history of other users. If NA is specified, the 
SQL execution history of all users will be retrieved. Default is the current user name.}

\item{df}{Result is a data.frame or a list of raw data.}
}
\value{
A data frame.
}
\description{
Getting the SQL execution is for being able to re-execute a previously submitted own SQL query (regular users)
and for auditing users SQL activity (administrators only).
}
\examples{
\dontrun{
o <- opal.login('administrator','password', url='https://opal-demo.obiba.org')
# with project context
opal.sql_history(o, 'CNSIM')
# without project context
opal.sql_history(o, NA)
# with or without project context
opal.sql_history(o)
opal.logout(o)
}
}
