% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gwas_qqman.R
\name{plot_qqman}
\alias{plot_qqman}
\title{Plot GWAS QQ and Manhattan Plots}
\usage{
plot_qqman(
  plink_assoc_file,
  pheno_name,
  maf_filter = NULL,
  output_graphics = "png",
  save_plot = TRUE,
  lambda1_qq_pos = c(2.1, -5.5),
  lambda2_qq_pos = c(1.565, -4)
)
}
\arguments{
\item{plink_assoc_file}{Path to the PLINK association file.}

\item{pheno_name}{Phenotype name.}

\item{maf_filter}{Minor allele frequency filter, Default: NULL}

\item{output_graphics}{Output graphics format, Default: 'png'}

\item{save_plot}{Logical, whether to save plots to files. If FALSE, plots are only displayed. Default: TRUE}

\item{lambda1_qq_pos}{A numeric vector of length 2 specifying the \code{c(hjust, vjust)} for the lambda text in the QQ plot. Default: \code{c(2.1, -5.5)}.}

\item{lambda2_qq_pos}{A numeric vector of length 2 specifying the \code{c(hjust, vjust)} for the SNP count (N) text in the QQ plot. Default: \code{c(1.565, -4.0)}.}
}
\value{
A list containing the ggplot objects for the Manhattan and QQ plots.
}
\description{
Create GWAS QQ & Manhattan Plots.
}
\details{
This function reads a PLINK association file and generates Manhattan and QQ plots for the GWAS results.
}
\section{Font Information}{

The MetroSans font included in this package is sourced from
\url{https://fontshub.pro/font/metro-sans-download#google_vignette}.
It is intended for academic research and non-commercial use only. For commercial use, please contact the font copyright holder.

The font files are included in the package's inst/extdata directory and are automatically loaded for plotting.
}

\examples{
\donttest{
  sample_file <- system.file("extdata", "sample_gwas.assoc.linear", package = "omixVizR")
  
  # Check if the file exists before running the example
  if (file.exists(sample_file)) {
    # Run the function with the sample data
    plots <- plot_qqman(
      plink_assoc_file = sample_file,
      pheno_name = "SamplePheno",
      save_plot = FALSE
    )
    # You can then access the plots like this:
    # print(plots$manhattan_plot)
    # print(plots$qq_plot)
  } else {
    message("Sample file not found, skipping example.")
  }
}
}
\seealso{
\href{https://CRAN.R-project.org/package=lulab.utils}{lulab.utils}
}
\author{
Zhen Lu \href{mailto:luzh29@mail2.sysu.edu.cn}{luzh29@mail2.sysu.edu.cn}

Yanhong Liu \href{mailto:liuyh275@mail2.sysu.edu.cn}{liuyh275@mail2.sysu.edu.cn}

Siyang Liu \href{mailto:liusy99@mail.sysu.edu.cn}{liusy99@mail.sysu.edu.cn}
}
