% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addTransit.R
\name{addTransit}
\alias{addTransit}
\title{To add transit compartments to the model}
\usage{
addTransit(
  ui,
  ntransit,
  central = "central",
  depot = "depot",
  transit = "transit",
  ktr = "ktr",
  ka = "ka"
)
}
\arguments{
\item{ui}{The model as a function}

\item{ntransit}{the number of transit compartments to be added}

\item{central}{central compartment name}

\item{depot}{depot compartment name}

\item{transit}{the transit compartment prefix}

\item{ktr}{the parameter name for the transit compartment rate}

\item{ka}{absorption rate parameter name}
}
\value{
a model with transit compartment added

This matches

`dose->a0->a1->abs cmt->central`

But `a0` is depot so dosing records labeled depot do not need to be
changed

The abs cmt becomes the last "transit" compartment

This is simply for convenience
}
\description{
To add transit compartments to the model
}
\examples{
readModelDb("PK_1cmt_des") |> addTransit(3)
}
\seealso{
Other absorption: 
\code{\link{addWeibullAbs}()},
\code{\link{removeTransit}()}
}
\concept{absorption}
