% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_mode.R
\name{stat_mode}
\alias{stat_mode}
\title{Statistical Mode}
\usage{
stat_mode(x, ..., na.rm = FALSE)
}
\arguments{
\item{x}{A vector of data values.}

\item{...}{Further arguments, currently unused.}

\item{na.rm}{a logical evaluating to \code{TRUE} or \code{FALSE} indicating whether
\code{NA} values should be stripped before the computation proceeds.}
}
\value{
The statistical mode with the same type as the input vector x.
}
\description{
Computes the statistical mode, i.e. the value that appears most often in a
vector. Returns the first match, if TRUE for multiple values.
}
\examples{
vector_numeric <- sample(1:5, 15, TRUE)
vector_numeric
stat_mode(vector_numeric)

vector_character <- sample(LETTERS[1:5], 15, TRUE)
vector_character
stat_mode(vector_character)
}
