% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_start.R
\name{obj_function}
\alias{obj_function}
\title{Elastic net objective function value}
\usage{
obj_function(
  y,
  mu,
  weights,
  family,
  lambda,
  alpha,
  coefficients,
  vp,
  view_components,
  rho
)
}
\arguments{
\item{y}{Quantitative response variable.}

\item{mu}{Model's predictions for \code{y}.}

\item{weights}{Observation weights.}

\item{family}{A description of the error distribution and link function to be
used in the model. This is the result of a call to a family function.}

\item{lambda}{A single value for the \code{lambda} hyperparameter.}

\item{alpha}{The elasticnet mixing parameter, with \eqn{0 \le \alpha \le 1}.}

\item{coefficients}{The model's coefficients (excluding intercept).}

\item{vp}{Penalty factors for each of the coefficients.}

\item{view_components}{a list of lists containing indices of coefficients and associated covariate (view) pairs}

\item{rho}{the fusion parameter}
}
\description{
Returns the elastic net objective function value.
}
