% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrbin.R
\name{mrbinrun}
\alias{mrbinrun}
\title{A function performing all data read and processing steps.}
\usage{
mrbinrun(
  createbins = TRUE,
  process = TRUE,
  mrbinResults = NULL,
  silent = TRUE,
  graphics = TRUE
)
}
\arguments{
\item{createbins}{If TRUE, new bin data is generated}

\item{process}{If TRUE, bin data is processed, e.g. by noise removal, atnv, etc.}

\item{mrbinResults}{An mrbin object. Needs to be provided only if createbins is FALSE}

\item{silent}{If set to FALSE, no new time calculation is performed}

\item{graphics}{Controls whether pop-up windows are shown for selections. Defaults to TRUE.}
}
\value{
An invisible mrbin object
}
\description{
This function reads parameters from the global variable mrbin.env$mrbin$parameters and
performs the following operations:
Reading NMR files, creating bins, removing solvent area, removing additional
user-defined areas, summing up bins that contain unstable peaks such as
citric acid, removes noise bins, crops HSQC spectra to the diagonal area,
performs PQN scaling, replaces negative values, log transforms and displays a
PCA plot. Parameters are then saved in a text file. These can be recreated
using recreatemrbin().
}
\examples{
resetEnv()
setParam(parameters=list(dimension="2D",binwidth2D=0.1,binheight=5,
   binRegion=c(8,1,15,140),PQNScaling="No",tryParallel=TRUE,useAsNames="Spectrum titles",
   fixNegatives="No",logTrafo="No",signal_to_noise2D=10,solventRegion=c(5.5,4.2),
   NMRfolders=c(system.file("extdata/1/12/pdata/10",package="mrbin"),
                system.file("extdata/2/12/pdata/10",package="mrbin"),
                system.file("extdata/3/12/pdata/10",package="mrbin"))))
results<-mrbinrun()
}
