% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/na.descript.R
\name{na.descript}
\alias{na.descript}
\title{Descriptive Statistics for Missing Data in Single-Level, Two-Level and Three-Level Data}
\usage{
na.descript(data, ..., cluster = NULL,  table = FALSE, digits = 2,
            as.na = NULL, write = NULL, append = TRUE, check = TRUE,
            output = TRUE)
}
\arguments{
\item{data}{a data frame with incomplete data, where missing
values are coded as \code{NA}.}

\item{...}{an expression indicating the variable names in \code{data},
e.g., \code{na.descript(dat, x1, x2, x3)}. Note that the operators
\code{.}, \code{+}, \code{-}, \code{~}, \code{:}, \code{::},
and \code{!} can also be used to select variables, see 'Details'
in the \code{\link{df.subset}} function.}

\item{cluster}{a character string indicating the name of the cluster
variable in \code{data} for two-level data,
a character vector indicating the names of the cluster
variables in \code{data} for three-level data, or a vector
or data frame representing the nested grouping structure
(i.e., group or cluster variables). Alternatively, a
character string or character vector indicating the variable
name(s) of the cluster variable(s) in \code{data}. Note that
the cluster variable at Level 3 come first in a three-level
model, i.e., \code{cluster = c("level3", "level2")}.}

\item{table}{logical: if \code{TRUE}, a frequency table with number of
observed values (\code{"nObs"}), percent of observed values
(\code{"pObs"}), number of missing values (\code{"nNA"}),
and percent of missing values (\code{"pNA"}) is printed for
each variable on the console.}

\item{digits}{an integer value indicating the number of decimal places to
be used for displaying percentages.}

\item{as.na}{a numeric vector indicating user-defined missing values,
i.e. these values are converted to \code{NA} before conducting
the analysis.}

\item{write}{a character string naming a file for writing the output into
either a text file with file extension \code{".txt"} (e.g.,
\code{"Output.txt"}) or Excel file with file extension
\code{".xlsx"}  (e.g., \code{"Output.xlsx"}). If the file
name does not contain any file extension, an Excel file will
be written.}

\item{append}{logical: if \code{TRUE} (default), output will be appended
to an existing text file with extension \code{.txt} specified
in \code{write}, if \code{FALSE} existing text file will be
overwritten.}

\item{check}{logical: if \code{TRUE} (default), argument specification is checked.}

\item{output}{logical: if \code{TRUE} (default), output is shown on the console.}
}
\value{
Returns an object of class \code{misty.object}, which is a list with following
entries:
  \item{\code{call}}{function call}
  \item{\code{type}}{type of analysis}
  \item{\code{data}}{data frame used for the current analysis}
  \item{\code{args}}{specification of function arguments}
  \item{\code{result}}{list with results}
}
\description{
This function computes descriptive statistics for missing data in single-level,
two-level, and three-level data, e.g. number of incomplete cases, number
of missing values, and summary statistics for the number of missing
values across all variables.
}
\examples{
#----------------------------------------------------------------------------
# Single-Level Data

# Example 1: Descriptive statistics for missing data
na.descript(airquality)

# Example 2: Descriptive statistics for missing data, print results with 3 digits
na.descript(airquality, digits = 3)

# Example 3: Descriptive statistics for missing data with frequency table
na.descript(airquality, table = TRUE)

#----------------------------------------------------------------------------
# Two-Level Data

# Load data set "Demo.twolevel" in the lavaan package
data("Demo.twolevel", package = "lavaan")

# Example 4: Descriptive statistics for missing data
na.descript(Demo.twolevel, cluster = "cluster")

#----------------------------------------------------------------------------
# Three-Level Data

# Create arbitrary three-level data
Demo.threelevel <- data.frame(Demo.twolevel, cluster2 = Demo.twolevel$cluster,
                                             cluster3 = rep(1:10, each = 250))

# Example 5: Descriptive statistics for missing data
na.descript(Demo.threelevel, cluster = c("cluster3", "cluster2"))

\dontrun{
#----------------------------------------------------------------------------
# Write Results

# Example 6a: Write Results into a text file
na.descript(airquality, table = TRUE, write = "NA_Descriptives.txt")

# Example 6b: Write Results into a Excel file
na.descript(airquality, table = TRUE, write = "NA_Descriptives.xlsx")}
}
\references{
Enders, C. K. (2010). \emph{Applied missing data analysis}. Guilford Press.

Graham, J. W. (2009). Missing data analysis: Making it work in the real world.
\emph{Annual Review of Psychology, 60}, 549-576.
https://doi.org/10.1146/annurev.psych.58.110405.085530

van Buuren, S. (2018). \emph{Flexible imputation of missing data} (2nd ed.).
Chapman & Hall.
}
\seealso{
\code{\link{write.result}}, \code{\link{as.na}}, \code{\link{na.as}},
\code{\link{na.auxiliary}}, \code{\link{na.coverage}}, \code{\link{na.indicator}},
\code{\link{na.pattern}}, \code{\link{na.prop}}, \code{\link{na.test}}
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
}
