% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multilevel.omega.R
\name{multilevel.omega}
\alias{multilevel.omega}
\title{Multilevel Composite Reliability}
\usage{
multilevel.omega(data, ..., cluster, rescov = NULL,
                 const = c("within", "shared", "config"),
                 fix.resid = NULL, optim.method = c("nlminb", "em"),
                 missing = c("listwise", "fiml"), nrep = 100000, seed = NULL,
                 conf.level = 0.95, print = c("all", "omega", "item"),
                 digits = 2, as.na = NULL, write = NULL, append = TRUE,
                 check = TRUE, output = TRUE)
}
\arguments{
\item{data}{a data frame. Multilevel confirmatory factor
analysis based on a measurement model with one factor
at the Within level and one factor at the Between level
comprising all variables in the data frame is
conducted. Note that the cluster variable specified in
\code{cluster} is excluded from \code{data} when specifying
the argument \code{cluster} using the variable name of the
cluster variable.}

\item{...}{an expression indicating the variable names in \code{data},
e.g., \code{multilevel.omega(dat, x1, x2, x3, cluster = "cluster")}.
Note that the operators \code{.}, \code{+}, \code{-},
\code{~}, \code{:}, \code{::}, and \code{!} can also be
used to select variables, see 'Details' in the
\code{\link{df.subset}} function.}

\item{cluster}{either a character string indicating the variable name of
the cluster variable in \code{data}, or a
vector representing the nested grouping structure (i.e.,
group or cluster variable).}

\item{rescov}{a character vector or a list of character vectors for specifying
residual covariances at the Within level, e.g. \code{rescov = c("x1", "x2")}
for specifying a residual covariance between indicators \code{x1}
and \code{x2} at the Within level or \code{rescov = list(c("x1", "x2"), c("x3", "x4"))}
for specifying residual covariances between indicators \code{x1}
and \code{x2}, and indicators \code{x3} and \code{x4} at
the Within level. Note that residual covariances at the
Between level cannot be  specified using this function.}

\item{const}{a character string indicating the type of construct(s), i.e.,
\code{"within"} for within-cluster constructs, \code{"shared"}
for shared cluster-level constructs, and \code{"config"}
(default) for configural cluster constructs.}

\item{fix.resid}{a character vector for specifying residual variances to be
fixed at 0 at the Between level, e.g., \code{fix.resid = c("x1", "x3")}
to fix residual variances of indicators \code{x1} and \code{x2}
at the Between level at 0. Note that it is also possible
to specify \code{fix.resid = "all"} which fixes all residual
variances at the Between level at 0 in line with the strong
factorial measurement invariance assumption across cluster.}

\item{optim.method}{a character string indicating the optimizer, i.e., \code{"nlminb"}
(default) for the unconstrained and bounds-constrained
quasi-Newton method optimizer and \code{"em"} for the
Expectation Maximization (EM) algorithm.}

\item{missing}{a character string indicating how to deal with missing data,
i.e., \code{"listwise"} for listwise deletion or \code{"fiml"}
(default) for full information maximum likelihood (FIML)
method.}

\item{nrep}{an integer value indicating the number of Monte Carlo
repetitions for computing confidence intervals.}

\item{seed}{a numeric value specifying the seed of the random number
generator for computing the Monte Carlo confidence interval.}

\item{conf.level}{a numeric value between 0 and 1 indicating the confidence
level of the interval.}

\item{print}{a character vector indicating which results to show, i.e.
\code{"all"} (default), for all results \code{"omega"} for
omega, and \code{"item"} for item statistics.}

\item{digits}{an integer value indicating the number of decimal places
to be used for displaying results. Note that loglikelihood,
information criteria and chi-square test statistic is
printed with \code{digits} minus 1 decimal places.}

\item{as.na}{a numeric vector indicating user-defined missing values,
i.e. these values are converted to \code{NA} before conducting
the analysis. Note that \code{as.na()} function is only
applied to \code{data} but not to \code{cluster}.}

\item{write}{a character string naming a file for writing the output into
either a text file with file extension \code{".txt"} (e.g.,
\code{"Output.txt"}) or Excel file with file extension
\code{".xlsx"}  (e.g., \code{"Output.xlsx"}). If the file
name does not contain any file extension, an Excel file will
be written.}

\item{append}{logical: if \code{TRUE} (default), output will be appended
to an existing text file with extension \code{.txt} specified
in \code{write}, if \code{FALSE} existing text file will be
overwritten.}

\item{check}{logical: if \code{TRUE} (default), argument specification, convergence
and model identification is checked.}

\item{output}{logical: if \code{TRUE} (default), output is shown.}
}
\value{
\item{\code{call}}{function call}
\item{\code{type}}{type of analysis}
\item{\code{data}}{data frame specified in \code{data} including the group variable
                   specified in \code{cluster}}
\item{\code{args}}{specification of function arguments}
\item{\code{model}}{specified model}
\item{\code{model.fit}}{fitted lavaan object (\code{mod.fit})}
\item{\code{check}}{results of the convergence and model identification check}
\item{\code{result}}{list with result tables, i.e., \code{omega} for the coefficient
                     omega including Monte Carlo confidence interval and
                     \code{itemstat} for descriptive statistics}
}
\description{
This function computes point estimate and Monte Carlo confidence interval for
the multilevel composite reliability defined by Lai (2021) for a within-cluster
construct, shared cluster-level construct, and configural cluster construct by
calling the \code{cfa} function in the R package \pkg{lavaan}.
}
\note{
The function uses the functions \code{lavInspect}, \code{lavTech}, and \code{lavNames},
provided in the R package \pkg{lavaan} by Yves Rosseel (2012). The internal function
\code{.internal.mvrnorm} is a copy of the \code{mvrnorm} function in the package
\pkg{MASS} by Venables and Ripley (2002).
}
\examples{
\dontrun{

# Load data set "Demo.twolevel" in the lavaan package
data("Demo.twolevel", package = "lavaan")

#----------------------------------------------------------------------------
# Cluster variable specification

# Example 1a: Specification using the argument '...'
multilevel.omega(Demo.twolevel, y1:y4, cluster = "cluster")

# Example 1b: Alternative specification with cluster variable 'cluster' in 'data'
multilevel.omega(Demo.twolevel[, c("y1", "y2", "y3", "y4", "cluster")], cluster = "cluster")

# Example 1b: Alternative specification with cluster variable 'cluster' not in 'data'
multilevel.omega(Demo.twolevel[, c("y1", "y2", "y3", "y4")], cluster = Demo.twolevel$cluster)

#----------------------------------------------------------------------------
# Type of construct

# Example 2a: Within-Cluster Construct
multilevel.omega(Demo.twolevel[, c("y1", "y2", "y3", "y4")],
                 cluster = Demo.twolevel$cluster, const = "within")

# Example 2b: Shared Cluster-Level Construct
multilevel.omega(Demo.twolevel, y1, y2, y3, y4, cluster = "cluster", const = "shared")

# Example 2c: Configural Construct
multilevel.omega(Demo.twolevel, y1, y2, y3, y4, cluster = "cluster", const = "config")

#----------------------------------------------------------------------------
# Residual covariance at the Within level and residual variance at the Between level

# Example 3a: Residual covariance between "y4" and "y5" at the Within level
multilevel.omega(Demo.twolevel, y1, y2, y3, y4, cluster = "cluster", const = "config",
                 rescov = c("y3", "y4"))

# Example 3b: Residual variances of 'y1' at the Between level fixed at 0
multilevel.omega(Demo.twolevel, y1, y2, y3, y4, cluster = "cluster", const = "config",
                 fix.resid = c("y1", "y2"), digits = 3)

#----------------------------------------------------------------------------
# Write results

# Example 4a: Write results into a text file
multilevel.omega(Demo.twolevel[, c("y1", "y2", "y3", "y4")],
                 cluster = Demo.twolevel$cluster, write = "Multilevel_Omega.txt")

# Example 4b: Write results into a Excel file
multilevel.omega(Demo.twolevel, y1, y2, y3, y4, cluster = "cluster",
                 write = "Multilevel_Omega.xlsx")
}
}
\references{
Lai, M. H. C. (2021). Composite reliability of multilevel data: It’s about
observed scores and construct meanings. \emph{Psychological Methods, 26}(1),
90–102. https://doi.org/10.1037/met0000287

Rosseel, Y. (2012). lavaan: An R Package for Structural Equation Modeling.
\emph{Journal of Statistical Software, 48}, 1-36. https://doi.org/10.18637/jss.v048.i02

Venables, W. N., Ripley, B. D. (2002).\emph{Modern Applied Statistics with S} (4th ed.).
Springer. https://www.stats.ox.ac.uk/pub/MASS4/.
}
\seealso{
\code{\link{item.omega}}, \code{\link{multilevel.cfa}}, \code{\link{multilevel.fit}},
\code{\link{multilevel.invar}}, \code{\link{multilevel.cor}},
\code{\link{multilevel.descript}}
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
}
