% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setup.R
\name{pso_setting}
\alias{pso_setting}
\title{Set PSO Optimization Settings}
\usage{
pso_setting(
  n_swarm = 32,
  max_iter = 128,
  early_stopping = 10,
  tol = 0.01,
  c1 = 2.05,
  c2 = 2.05,
  w0 = 1.2,
  w1 = 0.2,
  w_var = 0.8,
  vk = 4
)
}
\arguments{
\item{n_swarm}{Integer. Number of particles in the swarm.}

\item{max_iter}{Integer. Maximum number of iterations.}

\item{early_stopping}{Integer. The frequency, i.e. number of iterations, of validating the design optimality using equivalence theorem. The optimization process stops once maximum directional derivative is approximately 1.}

\item{tol}{Numeric. Convergence tolerance. The algorithm stops if \code{abs(max_directional_derivative - 1) < tol}.}

\item{c1}{Numeric. Cognitive acceleration coefficient. Default value is 2.05.}

\item{c2}{Numeric. Social acceleration coefficient. Default value is 2.05.}

\item{w0}{Numeric. Starting inertia weight. Default value is 1.2.}

\item{w1}{Numeric. Ending inertia weight. Default value is 0.2.}

\item{w_var}{Numeric. A number between \eqn{[0, 1]} that controls the percentage of iterations during which PSO linearly decrease inertia weight from \code{w0} to \code{w1}. Default value is 0.8.}

\item{vk}{Numeric. Velocity clamping factor. Default value is 4.}
}
\value{
A list of PSO hyperparameters.
}
\description{
Define hyperparameters for particle swarm optimization (PSO).
}
\examples{
pso_info <- pso_setting(n_swarm=32, max_iter=128, early_stopping=10, tol=0.01)
}
