#' @title
#' Introduction to microeco package (\href{https://github.com/ChiLiubio/microeco}{https://github.com/ChiLiubio/microeco})
#' 
#' @description
#' For the detailed tutorial on microeco package, please follow the links:\cr
#' Online tutorial website: \href{https://chiliubio.github.io/microeco_tutorial/}{https://chiliubio.github.io/microeco_tutorial/} \cr
#' Download tutorial: \href{https://github.com/ChiLiubio/microeco_tutorial/releases}{https://github.com/ChiLiubio/microeco_tutorial/releases}
#' 
#' For each R6 class, please open the help document by searching the class name.
#' For example, to search microtable class, please run the command \code{help(microtable)} or \code{?microtable}.\cr
#' Another way to open the help document of R6 class is to click the following links collected:\cr
#' \code{\link{microtable}}\cr
#' \code{\link{trans_abund}}\cr
#' \code{\link{trans_venn}}\cr
#' \code{\link{trans_alpha}}\cr
#' \code{\link{trans_beta}}\cr
#' \code{\link{trans_diff}}\cr
#' \code{\link{trans_network}}\cr
#' \code{\link{trans_nullmodel}}\cr
#' \code{\link{trans_classifier}}\cr
#' \code{\link{trans_env}}\cr
#' \code{\link{trans_func}}\cr
#' \code{\link{trans_norm}}\cr
#' 
#' To report bugs or discuss questions, please use Github Issues (\href{https://github.com/ChiLiubio/microeco/issues}{https://github.com/ChiLiubio/microeco/issues}).
#' Before creating a new issue, 
#' please read the guideline (\href{https://chiliubio.github.io/microeco_tutorial/notes.html#github-issues}{https://chiliubio.github.io/microeco_tutorial/notes.html#github-issues}).
#' 
#' To cite microeco package in publications, please run the following command to get the reference: \code{citation("microeco")}
#' 
#' Reference:\cr
#' Chi Liu, Yaoming Cui, Xiangzhen Li and Minjie Yao. 2021. microeco: an R package for data mining in microbial community ecology. 
#' FEMS Microbiology Ecology, 97(2): fiaa255. DOI:10.1093/femsec/fiaa255
#' 
#' @keywords Description
#' @name microeco
NULL
