% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/skeletonMI.R
\name{skeletonMI}
\alias{skeletonMI}
\title{Estimate (Initial) Skeleton of a DAG using the PC Algorithm for Multiple
Imputed Data Sets of Continuous Data}
\usage{
skeletonMI(
  data,
  alpha,
  labels,
  p,
  method = c("stable", "original"),
  m.max = Inf,
  fixedGaps = NULL,
  fixedEdges = NULL,
  NAdelete = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{data}{An object of type mids, which stands for 'multiply imputed
data set', typically created by a call to function mice()}

\item{alpha}{Significance level}

\item{labels}{(Optional) character vector of variable (or "node") names.
Typically preferred to specifying p}

\item{p}{(Optional) number of variables (or nodes). May be specified if
labels are not, in which case labels is set to 1:p.}

\item{method}{Character string specifying method; the default, "stable"
provides an order-independent skeleton, see
\code{\link[pcalg:pc]{pcalg::pc()}} for details.}

\item{m.max}{Maximal size of the conditioning sets that are considered in
the conditional independence tests.}

\item{fixedGaps}{Logical symmetric matrix of dimension p*p. If entry [i,j]
is true, the edge i-j is removed before starting the
algorithm. Therefore, this edge is guaranteed to be absent
in the resulting graph.}

\item{fixedEdges}{A logical symmetric matrix of dimension p*p. If entry [i,j]
is true, the edge i-j is never considered for removal.
Therefore, this edge is guaranteed to be present in the
resulting graph.}

\item{NAdelete}{Logical needed for the case indepTest(*) returns NA.
If it is true, the corresponding edge is deleted, otherwise not.}

\item{verbose}{If TRUE, detailed output is provided.}
}
\value{
See \code{\link[pcalg:skeleton]{pcalg::skeleton()}} for more details.
}
\description{
This function is a modification of \code{\link[pcalg:skeleton]{pcalg::skeleton()}}
to be used for multiple imputation.
}
\note{
This is a modified function of \code{\link[pcalg:skeleton]{pcalg::skeleton()}}
from the package 'pcalg' (Kalisch et al., 2012;
http://www.jstatsoft.org/v47/i11/).
}
\examples{

data(gmG)
n <- nrow(gmG8$x)
V <- colnames(gmG8$x) # labels aka node names
## estimate Skeleton
data_mids <- mice(gmG8$x, printFlag = FALSE)
(skel.fit <- skeletonMI(data = data_mids, alpha = 0.01, labels = V, verbose = FALSE))
}
\author{
Original code by Markus Kalisch, Martin Maechler, Alain Hauser, and Diego Colombo.
Modifications by Ronja Foraita.
}
