% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NullMaker.R
\name{NullMaker}
\alias{NullMaker}
\title{Null matrix creator}
\usage{
NullMaker(comm, sims = 1000, method = "r1", ordinate = TRUE, scores = 1,
  allowEmpty = FALSE, verbose = FALSE, seed = 1)
}
\arguments{
\item{comm}{community data in the form of a presence absence matrix}

\item{sims}{number of simulated null matrices to use in analysis}

\item{method}{null model randomization method. See details below.}

\item{ordinate}{logical. Would you like to ordinate the null matrices?
Default is TRUE.}

\item{scores}{Axis scores to ordinate matrix. 1: primary axis scores
(default) 2: secondary axis scores. See Details.}

\item{allowEmpty}{logical argument indicating whether to allow null
matrices to have empty rows or columns}

\item{verbose}{Logical. Prints a graphical progress bar that tracks the
creation of null matrices. Useful for conservative null models on large
and/or sparse data.}

\item{seed}{seed for simulating the null model. Null matrices should be repeatable.}
}
\value{
rmats -- A list of length(sim) containing the null matrices
}
\description{
Creates null matrices based on the constraints of the null model algorithm
('method'). Also allows for null matrices with a species that occurs at no
sites, or a site without any species to be removed from the suite of
simulated null matrices. This function borrows heavily from the
commsimulator() function in the 'vegan' package, but also allows for the
fixed-fixed null model.
}
\details{
'method' is the null model algorithm used to create the null matrices. The
choice of a null algorithm is nontrivial. Leibold & Mikkelson advocated the
use of equiprobable rows and columns (provided that rows and columns had at
least one entry). This method is called 'r00'. Methods maintaining row
(site) frequencies include 'r0','r1' & 'r2', whereas species (column)
occurrences are preserved with fixed column methods such as 'c0'. The
default method argument is 'r1', which maintains the species richness of a
site (row totals) and fills species ranges (columns) based on their marginal
probabilities. Arguably the most conservative null algorithm is the fixed
row - fixed column total null, which can be attained using many of swap
algorithms described in the vegan package (sequential methods like 'tswap',
'swap', and non-sequential 'quasiswap' and 'backtracking'). Other
randomization methods are also available. See the help file for 'commsim',
or Wright et al. 1998 for more information.
}
\examples{

#define an interaction matrix
data(TestMatrices)
intmat <- TestMatrices[[7]]

#creation of the null matrices
nulls <- NullMaker(intmat, sims=100, method='r1')

}
\references{
J. Oksanen, F.G. Blanchet, R. Kindt, P. Legendre, P.R. Minchin,
R.B. O'Hara, G.L. Simpson, P. Solymos, M.H.H. Stevens and H. Wagner (2012).
vegan: Community Ecology Package. R package version 2.0-4.
http://CRAN.R-project.org/package=vegan
}
\seealso{
nullmodel(), permatfull(), commsim()
}
\author{
Tad Dallas and John Lefcheck
}
\keyword{ordination}
