% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writers.R
\name{write_greengenes}
\alias{write_greengenes}
\title{Write an imitation of the Greengenes database}
\usage{
write_greengenes(
  obj,
  tax_file = NULL,
  seq_file = NULL,
  tax_names = obj$get_data("taxon_names")[[1]],
  ranks = obj$get_data("gg_rank")[[1]],
  ids = obj$get_data("gg_id")[[1]],
  sequences = obj$get_data("gg_seq")[[1]]
)
}
\arguments{
\item{obj}{A taxmap object}

\item{tax_file}{(\code{character} of length 1) The file path to save the
taxonomy file.}

\item{seq_file}{(\code{character} of length 1) The file path to save the
sequence fasta file. This is optional.}

\item{tax_names}{(\code{character} named by taxon ids) The names of taxa}

\item{ranks}{(\code{character} named by taxon ids) The ranks of taxa}

\item{ids}{(\code{character} named by taxon ids) Sequence ids}

\item{sequences}{(\code{character} named by taxon ids) Sequences}
}
\description{
Attempts to save taxonomic and sequence information of a taxmap object in the
Greengenes output format. If the taxmap object was created using
\code{\link{parse_greengenes}}, then it should be able to replicate the
format exactly with the default settings.
}
\details{
The taxonomy output file has a format like:

\preformatted{
228054  k__Bacteria; p__Cyanobacteria; c__Synechococcophycideae; o__Synech...
844608  k__Bacteria; p__Cyanobacteria; c__Synechococcophycideae; o__Synech...
...
}

The optional sequence file has a format like:

\preformatted{
>1111886 
AACGAACGCTGGCGGCATGCCTAACACATGCAAGTCGAACGAGACCTTCGGGTCTAGTGGCGCACGGGTGCGTA...
>1111885 
AGAGTTTGATCCTGGCTCAGAATGAACGCTGGCGGCGTGCCTAACACATGCAAGTCGTACGAGAAATCCCGAGC...
...
}
}
\seealso{
Other writers: 
\code{\link{make_dada2_asv_table}()},
\code{\link{make_dada2_tax_table}()},
\code{\link{write_mothur_taxonomy}()},
\code{\link{write_rdp}()},
\code{\link{write_silva_fasta}()},
\code{\link{write_unite_general}()}
}
\concept{writers}
