% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/30_align.R
\name{speaq_align}
\alias{speaq_align}
\title{Align Signals using 'speaq'}
\usage{
speaq_align(
  feat = gen_feat_mat(spectrum_data),
  maxShift = 50,
  spectrum_data = generate_lorentz_curves_sim(),
  si_size_real_spectrum = length(spectrum_data[[1]]$y_values),
  verbose = TRUE,
  show = FALSE,
  mfrow = c(2, 1)
)
}
\arguments{
\item{feat}{Output of \code{gen_feat_mat()}.}

\item{maxShift}{Maximum number of points along the "ppm-axis" which a value
can be moved by speaq package e.g. 50. 50 is a suitable starting value for
plasma spectra with a digital resolution of 128K. Note that this parameter
has to be individually optimized depending on the type of analyzed spectra
and the digital resolution. For urine which is more prone to chemical shift
variations this value most probably has to be increased.}

\item{spectrum_data}{Output of \code{generate_lorentz_curves()}.}

\item{si_size_real_spectrum}{Number of real data points in your original
spectra.}

\item{verbose}{Whether to print additional information during the alignment
process.}

\item{show}{Whether to plot the original and aligned spectra.}

\item{mfrow}{Layout to use for the plot. Passed on to \code{par()}. Use \code{mfrow = NULL} if the plot layout should not be changed.}
}
\value{
A matrix containing the integral values of the spectra after alignment.

There is one row per spectrum and one column per ppm value. The entry at
position \verb{i, j} holds the integral value of the signal from spectrum \code{i} that
has its center at position \code{j} after alignment by speaq. If there is no
signal with center \code{j} in spectrum \code{i}, entry \verb{i, j} is set to NA. The column
names of the matrix are the ppm values of the original spectra.

Example return matrix:

\if{html}{\out{<div class="sourceCode">}}\preformatted{    ...  3.59  3.55  3.57  3.56  3.55  3.54  3.53
  .----------------------------------------------> PPM
1 | NA   NA    0.20  NA    NA    NA    0.25  NA
2 | NA   NA    0.15  NA    NA    NA    0.13  NA
3 | NA   NA    NA    0.2   NA    NA    0.18  NA
SpNr
}\if{html}{\out{</div>}}
}
\description{
Performs signal alignment across the individual spectra using the 'speaq'
package (Beirnaert C, Meysman P, Vu TN, Hermans N, Apers S, Pieters L, et al.
(2018) speaq 2.0: A complete workflow for high-throughput 1D NMRspectra
processing and quantification. PLoS Comput Biol 14(3): e1006018.
https://www.doi.org/10.1371/journal.pcbi.1006018). The spectra deconvolution
process yields the signals of all spectra. Due to slight changes in
measurement conditions, e.g. pH variations, signal positions may vary
slightly across spectra. As a consequence, prior to further analysis signals
belonging to the same compound have to be aligned across spectra. This is the
purpose of the 'speaq' package.
}
\examples{
sim_subset <- metabodecon_file("bruker/sim_subset")
spectrum_data <- generate_lorentz_curves_sim(sim_subset)
feat <- gen_feat_mat(spectrum_data)
maxShift <- 200
M <- speaq_align(feat, maxShift, spectrum_data, show = TRUE)
str(M)
}
\author{
Initial version from Wolfram Gronwald.
Refactored by Tobias Schmidt in 2024.
}
