% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expect.R
\name{expect_deprecated}
\alias{expect_deprecated}
\alias{expect_defunct}
\title{Does expression produce lifecycle warnings or errors?}
\usage{
expect_deprecated(expr)

expect_defunct(expr)
}
\arguments{
\item{expr}{Expression that should produce a lifecycle warning or
error.}
}
\description{
These functions are equivalent to \code{\link[testthat:expect_warning]{testthat::expect_warning()}} and
\code{\link[testthat:expect_error]{testthat::expect_error()}} but check specifically for lifecycle
warnings or errors.

To test whether a deprecated feature still works without causing a
deprecation warning, set the \code{lifecycle_verbosity} option to
\code{"quiet"}.\preformatted{test_that("feature still works", \{
  withr::local_options(lifecycle_verbosity = "quiet")
  expect_true(my_deprecated_function())
\})
}
}
\details{
\code{expect_deprecated()} sets the \link[=verbosity]{lifecycle_verbosity}
option to \code{"warning"} to enforce deprecation warnings which are
otherwise only shown once every 8 hours.
}
