% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_lcsm.R
\name{plot_lcsm}
\alias{plot_lcsm}
\title{Plot simplified path diagram of univariate and bivariate latent change score models}
\usage{
plot_lcsm(
  lavaan_object,
  layout = NULL,
  lavaan_syntax = NULL,
  return_layout_from_lavaan_syntax = FALSE,
  lcsm = c("univariate", "bivariate"),
  lcsm_colours = FALSE,
  curve_covar = 0.5,
  what = "path",
  whatLabels = "est",
  edge.width = 1,
  node.width = 1,
  border.width = 1,
  fixedStyle = 1,
  freeStyle = 1,
  residuals = FALSE,
  label.scale = FALSE,
  sizeMan = 3,
  sizeLat = 5,
  intercepts = FALSE,
  fade = FALSE,
  nCharNodes = 0,
  nCharEdges = 0,
  edge.label.cex = 0.5,
  ...
)
}
\arguments{
\item{lavaan_object}{lavaan object of a univariate or bivariate latent change score model.}

\item{layout}{Matrix, specifying number and location of manifest and latent variables of LCS model specified in  \code{lavaan_object}.}

\item{lavaan_syntax}{String, lavaan syntax of the lavaan object specified in \code{lavaan_object}.
If \code{lavaan_syntax} is provided a layout matrix will be generated automatically.}

\item{return_layout_from_lavaan_syntax}{Logical, if TRUE and \code{lavaan_syntax} is provided, the layout matrix generated for \link[semPlot]{semPaths} will be returned for inspection of further customisation.}

\item{lcsm}{String, specifying whether lavaan_object represent a "univariate" or "bivariate" LCS model.}

\item{lcsm_colours}{Logical, if TRUE the following colours will be used to highlight different parts of the model: Observed variables (White); Latent true scores (Green); Latent change scores (Blue) ; Change factors (Yellow).}

\item{curve_covar}{See \link[semPlot]{semPaths}.}

\item{what}{See \code{semPlot}. "path" to show unweighted grey edges, "par" to show parameter estimates as weighted (green/red) edges}

\item{whatLabels}{See \link[semPlot]{semPaths}. "label" to show edge names as label, "est" for parameter estimates, "hide" to hide edge labels.}

\item{edge.width}{See \link[semPlot]{semPaths}.}

\item{node.width}{See \link[semPlot]{semPaths}.}

\item{border.width}{See \link[semPlot]{semPaths}.}

\item{fixedStyle}{See \link[semPlot]{semPaths}.}

\item{freeStyle}{See \link[semPlot]{semPaths}.}

\item{residuals}{See \link[semPlot]{semPaths}.}

\item{label.scale}{See \link[semPlot]{semPaths}.}

\item{sizeMan}{See \link[semPlot]{semPaths}.}

\item{sizeLat}{See \link[semPlot]{semPaths}.}

\item{intercepts}{See \link[semPlot]{semPaths}.}

\item{fade}{See \link[semPlot]{semPaths}.}

\item{nCharNodes}{See \link[semPlot]{semPaths}.}

\item{nCharEdges}{See \link[semPlot]{semPaths}.}

\item{edge.label.cex}{See \link[semPlot]{semPaths}.}

\item{...}{Other arguments passed on to \link[semPlot]{semPaths}.}
}
\value{
Plot
}
\description{
Note that the following three arguments are needed to create a plot (see below for more details):
\itemize{
\item \code{lavaan_object}: the lavaan fit object needs to be specified together with a
\item \code{lcsm}: a string indicating whether the latent change score model is "univariate" or "bivariate", and
\item \code{lavaan_syntax}: a separate object with the lavaan syntax as a string
}
}
\examples{
# Simplified plot of univariate lcsm
lavaan_syntax_uni <- fit_uni_lcsm(
  data = data_bi_lcsm,
  var = c("x1", "x2", "x3", "x4", "x5"),
  model = list(
    alpha_constant = TRUE,
    beta = TRUE,
    phi = TRUE
  ),
  return_lavaan_syntax = TRUE,
  return_lavaan_syntax_string = TRUE
)

lavaan_object_uni <- fit_uni_lcsm(
  data = data_bi_lcsm,
  var = c("x1", "x2", "x3", "x4", "x5"),
  model = list(
    alpha_constant = TRUE,
    beta = TRUE,
    phi = TRUE
  )
)

plot_lcsm(
  lavaan_object = lavaan_object_uni,
  what = "cons", whatLabels = "invisible",
  lavaan_syntax = lavaan_syntax_uni,
  lcsm = "univariate"
)
\dontrun{
# Simplified plot of bivariate lcsm
lavaan_syntax_bi <- fit_bi_lcsm(
  data = data_bi_lcsm,
  var_x = c("x1", "x2", "x3", "x4", "x5"),
  var_y = c("y1", "y2", "y3", "y4", "y5"),
  model_x = list(
    alpha_constant = TRUE,
    beta = TRUE,
    phi = TRUE
  ),
  model_y = list(
    alpha_constant = TRUE,
    beta = TRUE,
    phi = TRUE
  ),
  coupling = list(
    delta_lag_xy = TRUE,
    delta_lag_yx = TRUE
  ),
  return_lavaan_syntax = TRUE,
  return_lavaan_syntax_string = TRUE
)

lavaan_object_bi <- fit_bi_lcsm(
  data = data_bi_lcsm,
  var_x = c("x1", "x2", "x3", "x4", "x5"),
  var_y = c("y1", "y2", "y3", "y4", "y5"),
  model_x = list(
    alpha_constant = TRUE,
    beta = TRUE,
    phi = TRUE
  ),
  model_y = list(
    alpha_constant = TRUE,
    beta = TRUE,
    phi = TRUE
  ),
  coupling = list(
    delta_lag_xy = TRUE,
    delta_lag_yx = TRUE
  )
)

plot_lcsm(
  lavaan_object = lavaan_object_bi,
  what = "cons", whatLabels = "invisible",
  lavaan_syntax = lavaan_syntax_bi,
  lcsm = "bivariate"
)
}

}
\references{
Sacha Epskamp (2019). semPlot: Path Diagrams and Visual Analysis of Various SEM Packages' Output. R package version 1.1.1.
\url{https://CRAN.R-project.org/package=semPlot/}
}
