% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PreprocessingFunctions.R
\name{preprocess_gaze}
\alias{preprocess_gaze}
\title{Interpolation and smoothing of gaze-vector}
\usage{
preprocess_gaze(
  gaze_raw,
  max_gap_ms = 75,
  marg_ms = 5,
  filter_ms = 15,
  xcol = "x.raw",
  ycol = "y.raw"
)
}
\arguments{
\item{gaze_raw}{Data frame containing unfiltered timestamp, x.raw and y.raw vectors.}

\item{max_gap_ms}{The maximum gaps defined as subsequent NAs in the data to interpolate over in milliseconds. Default 75 ms}

\item{marg_ms}{The margin in milliseconds before and after the gap to use as basis for interpolation.}

\item{filter_ms}{The size of the moving average window to use in smoothing. Default 15 ms}

\item{xcol}{Name of column containing unprocessed x coordinates}

\item{ycol}{Name of column containing unprocessed y coordinates}
}
\value{
data frame with gaze data after interpolation and filtering
}
\description{
Pre-processing gaze
Interpolate over gaps in data and smooth the x and y vectors using a moving average filter.
The gaze vector must contain the variables timestamp, and variables containing unfiltered x
and y coordinates. Default names: x.raw and y.raw. Timestamps are assumed to be in
milliseconds. The unprocessed x and y variables are kept under the names x.unprocessed and y.unprocessed for comparison.
The function will add the variable timestamp.t to the data frame before returning. This is a theoretical timestamp based on the detected median sample-to-sample
timestamp difference as compared to the actual registered time stamps in the data. This can be useful in some validation analyses.
}
\examples{
processed_gaze <- preprocess_gaze(sample.data.unprocessed)
}
