% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/islasso.R
\name{is.control}
\alias{is.control}
\title{Control Settings for islasso Model Fitting}
\usage{
is.control(
  sigma2 = -1,
  tol = 1e-05,
  itmax = 1000,
  stand = TRUE,
  trace = 0,
  nfolds = 5,
  seed = NULL,
  adaptive = FALSE,
  g = 0.5,
  b0 = NULL,
  V0 = NULL,
  c = 0.5
)
}
\arguments{
\item{sigma2}{Numeric. Fixed value of the dispersion parameter. If \code{-1} (default), it is estimated from data.}

\item{tol}{Numeric. Tolerance level to declare convergence. Default is \code{1e-5}.}

\item{itmax}{Integer. Maximum number of iterations. Default is \code{1000}.}

\item{stand}{Logical. If \code{TRUE} (default), standardizes covariates before fitting. Returned coefficients remain on the original scale.}

\item{trace}{Integer. Controls verbosity of the iterative procedure:
\itemize{
  \item \code{0} - no printing,
  \item \code{1} - compact printing,
  \item \code{2} - detailed printing,
  \item \code{3} - compact printing with Fisher scoring info (only for GLM).
}}

\item{nfolds}{Integer. Number of folds for CV if \code{lambda} is missing in \code{islasso}. Defaults to \code{5}.}

\item{seed}{Optional. Integer seed for reproducibility in cross-validation.}

\item{adaptive}{Logical. If \code{TRUE}, fits an adaptive LASSO. (Experimental)}

\item{g}{Numeric in \code{[0,1]}. Governs BIC selection: \code{g = 0} is standard BIC; \code{g = 0.5} is extended BIC.}

\item{b0}{Optional. Starting values for regression coefficients. If \code{NULL}, uses \code{glmnet} estimates.}

\item{V0}{Optional. Initial covariance matrix. Defaults to identity matrix if \code{NULL}.}

\item{c}{Numeric. Controls the weight in the induced smoothed LASSO. Default is \code{0.5}; use \code{-1} to recompute at every iteration.}
}
\value{
A list of control parameters for use in \code{\link{islasso}}.
}
\description{
Auxiliary function used to configure and customize the fitting process of \code{\link{islasso}} models.
}
\seealso{
\code{\link{islasso}}
}
\author{
Gianluca Sottile \email{gianluca.sottile@unipa.it}
}
