% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inspect_na.R
\name{inspect_na}
\alias{inspect_na}
\title{Summarise and compare the rate of missingness in one or two dataframes.}
\usage{
inspect_na(df1, df2 = NULL, show_plot = FALSE, alpha = 0.05)
}
\arguments{
\item{df1}{A data frame}

\item{df2}{An optional second data frame for making columnwise comparison of missingness.
Defaults to \code{NULL}.}

\item{show_plot}{Logical determining whether to return a plot in addition to tibble.
Default is \code{FALSE}.}

\item{alpha}{Alpha level for performing significance tests.  Defaults to 0.05.}
}
\value{
A tibble summarising the count and percentage of columnwise missingness 
for one or a pair of data frames.
}
\description{
Summarise and compare the rate of missingness in one or two dataframes.
}
\details{
When a single data frame is specified, the a tibble is returned which 
contains the count and percentage of missing values, with column names
\itemize{
  \item \code{col_name} character vector containing column names of \code{df1}.
  \item \code{cnt} integer vector containing the number of missing values by 
  column.
  \item \code{pcnt} the percentage of each column with missing values
}

When both \code{df1} and \code{df2} are specified, missingness is compared across 
columns occurring in both data frames.  A test of the null hypothesis that the rate 
of missingness is the same across the same column in either dataframe.
\itemize{
  \item \code{col_name} the name of the columns occurring in either \code{df1}
  \item \code{cnt_1}, \code{cnt_2} pair of integer vectors containing counts of missing entries
  for each column in \code{df1} and \code{df2}.
  \item \code{pcnt_1}, \code{pcnt_2} pair of columns containing percentage of missing entries
  for each column in \code{df1} and \code{df2}.
  \item \code{p_value} p-value associated with test of the rates of missingness.  Small 
  values indicate evidence that the rate of missingness differs for a column occurring 
  in both \code{df1} and \code{df2}.
}
}
\examples{
data("starwars", package = "dplyr")
# inspect missingness in starwars data
inspect_na(starwars)
# show the result as a barplot
inspect_na(starwars, show_plot = TRUE)
# compare two dataframes
inspect_na(starwars, starwars[1:30, ])
}
