% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MTDest.R
\name{MTDest}
\alias{MTDest}
\title{EM estimation of MTD parameters}
\usage{
MTDest(
  X,
  S,
  M = 0.01,
  init,
  iter = FALSE,
  nIter = 100,
  A = NULL,
  oscillations = FALSE
)
}
\arguments{
\item{X}{A vector or single-column data frame containing an MTD chain sample (\code{X[1]} is the most recent).}

\item{S}{A numeric vector of positive integers. Typically, \code{S} represents a set of relevant lags.}

\item{M}{A stopping point for the EM algorithm. If \code{M=NULL} the algorithm will run
for a total of \code{nIter} iteractions.}

\item{init}{A list with initial parameters: \code{p0} (optional), \code{lambdas} (required),
\code{pj} (required). The entries in \code{lambdas} are weights for the distribution \code{p0}
and the distributions present in the list \code{pj}. Therefore, the order in which the elements
appear in the vector \code{lambdas} is important for correct assignment. Please refer to the
\emph{Details} section for more information.}

\item{iter}{Logical. If \code{TRUE}, returns the number of iterations of the
algorithm, that is, the number of times the initial parameters were updated.}

\item{nIter}{An integer positive number with the maximum number of iterations.}

\item{A}{A vector with positive integers representing the state space. If not informed,
this function will set \code{A=unique(X)}.}

\item{oscillations}{Logical. If \code{TRUE}, the function will return the estimated oscillations
for the updated model along with the estimated parameters.}
}
\value{
A list with the estimated parameters of the MTD model.
}
\description{
Estimation of MTD parameters through the Expectation Maximization (EM) algorithm.
}
\details{
Regarding the \code{M} parameter: it functions as a stopping
criterion within the EM algorithm. When the difference between
the log-likelihood computed with the newly estimated parameters
and that computed with the previous parameters falls below \code{M},
the algorithm halts. Nevertheless, if the value of \code{nIter}
(which represents the maximum number of iterations) is smaller
than the number of iterations required to meet the \code{M} criterion,
the algorithm will conclude its execution when \code{nIter} is reached.
To ensure that the \code{M} criterion is effectively utilized, we
recommend using a higher value for \code{nIter}, which is set to a
default of 100.

Concerning the \code{init} parameter, it is expected to be a list
comprising either 2 or 3 entries. These entries consist of:
an optional vector named \code{p0}, representing an independent
distribution (the probability in the first entry of \code{p0} must be
that of the smallest element in \code{A} and so on), a required list
of matrices \code{pj}, containing a stochastic matrix for each
element of \code{S} ( the first matrix must refer to the smallest
element of \code{S} and so on), and a vector named \code{lambdas} representing
the weights, the first entry must be the weight for \code{p0}, and then one entry
for each element in \code{pj} list. If your MTD model does not have an independent
distribution \code{p0}, set \code{init$lambda[1]=0}.
}
\examples{
# Simulating data.
# Model:
MTD <- MTDmodel(Lambda=c(1,10),A=c(0,1),lam0=0.01)
# Sampling a chain:
X <- hdMTD::perfectSample(MTD,N=2000)

# Initial Parameters:
init <- list('p0'=c(0.4,0.6),'lambdas'=c(0.05,0.45,0.5),
  'pj'=list(matrix(c(0.2,0.8,0.45,0.55),byrow = TRUE,ncol=2),
   matrix(c(0.25,0.75,0.3,0.7),byrow = TRUE,ncol=2)))

# MTDest() ------------------------------------
MTDest(X,S=c(1,10),M=1,init)
MTDest(X,S=c(1,10),init=init,iter = TRUE)
MTDest(X,S=c(1,10),init=init,iter = TRUE,nIter=5)
MTDest(X,S=c(1,10),init=init,oscillations = TRUE)

}
\references{
Lebre, Sophie and Bourguignon, Pierre-Yves. (2008).
An EM algorithm for estimation in the Mixture Transition Distribution model.
\emph{Journal of Statistical Computation and Simulation}, \emph{78}(1), 1-15.
\doi{10.1080/00949650701266666}
}
