% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gtsummary_utilities.R
\name{gtsummary_utilities}
\alias{gtsummary_utilities}
\alias{bold_variable_group_headers}
\alias{italicize_variable_group_headers}
\alias{indent_levels}
\alias{indent_labels}
\title{Utilities for \code{gtsummary}}
\usage{
bold_variable_group_headers(x)

italicize_variable_group_headers(x)

indent_levels(x, indent = 8L)

indent_labels(x, indent = 4L)
}
\arguments{
\item{x}{A \code{gtsummary} object.}

\item{indent}{An integer indicating how many space to indent text.}
}
\description{
Utilities for tables generated with \link[gtsummary:gtsummary-package]{gtsummary}.
}
\examples{
\dontshow{if (rlang::is_installed("gtsummary")) withAutoprint(\{ # examplesIf}
\donttest{
library(gtsummary)
tbl <-
  trial |>
  tbl_summary(
    include = c(stage, grade, age, trt, response, death)
  ) |>
  add_variable_group_header(
    header = "Clinical situation at diagnosis",
    variables = c(stage, grade, age)
  ) |>
  add_variable_group_header(
    header = "Treatment and outcome",
    variables = c(trt, response, death)
  )
tbl

tbl |>
  bold_variable_group_headers() |>
  italicize_labels() |>
  indent_levels(indent = 8L)
}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[gtsummary:modify_bold_italic]{gtsummary::modify_bold()}}, \code{\link[gtsummary:modify_bold_italic]{gtsummary::modify_italic()}},
\code{\link[gtsummary:modify_indent]{gtsummary::modify_indent()}}
}
\keyword{utilities}
