% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gridpts_h1_hupdate.R
\name{h1}
\alias{h1}
\title{Initialize numerical integration for group sequential design}
\usage{
h1(r = 18, theta = 0, info = 1, a = -Inf, b = Inf)
}
\arguments{
\item{r}{Integer, at least 2; default of 18 recommended by Jennison and Turnbull.}

\item{theta}{Drift parameter for first analysis.}

\item{info}{Information at first analysis.}

\item{a}{Lower limit of integration (scalar).}

\item{b}{Upper limit of integration (scalar \verb{> a}).}
}
\value{
A list with grid points in \code{z}, numerical integration weights in \code{w},
and a normal density with mean \verb{mu = theta * sqrt\{I\}}
and variance 1 times the weight in \code{h}.
}
\description{
Compute grid points for first interim analysis in a group sequential design.
}
\details{
Mean for standard normal distribution under consideration is \code{mu = theta * sqrt(I)}.
}
\section{Specification}{

\if{latex}{
 \itemize{
   \item Compute drift at analysis 1.
   \item Compute deviation from drift.
   \item Compute standard normal density, multiply by grid weight.
   \item Return a tibble of z, w, and h.
  }
}
\if{html}{The contents of this section are shown in PDF user manual only.}
}

\examples{
# Replicate variance of 1, mean of 35
g <- h1(theta = 5, info = 49)
mu <- sum(g$z * g$h)
var <- sum((g$z - mu)^2 * g$h)

# Replicate p-value of 0.0001 by numerical integration of tail
g <- h1(a = qnorm(0.9999))
sum(g$h)
}
