% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractors.R
\name{nPers}
\alias{nPers}
\title{Number of persons}
\usage{
nPers(gpModel)
}
\arguments{
\item{gpModel}{object of class GPPM.}
}
\value{
Number of persons as a numeric.
}
\description{
Extracts the number of persons from a GPPM.
}
\examples{
\donttest{
data("demoLGCM")
lgcm <- gppm(
  "muI+muS*t", "varI+covIS*(t+t#)+varS*t*t#+(t==t#)*sigma",
  demoLGCM, "ID", "y"
)
numberPersons <- nPers(lgcm)
}
}
\seealso{
Other functions to extract from a GPPM: 
\code{\link{SE}()},
\code{\link{coef.GPPM}()},
\code{\link{confint.GPPM}()},
\code{\link{covFun}()},
\code{\link{fitted.GPPM}()},
\code{\link{getData}()},
\code{\link{getIntern}()},
\code{\link{logLik.GPPM}()},
\code{\link{maxNObs}()},
\code{\link{meanFun}()},
\code{\link{nObs}()},
\code{\link{nPars}()},
\code{\link{nPreds}()},
\code{\link{parEsts}()},
\code{\link{pars}()},
\code{\link{preds}()},
\code{\link{vcov.GPPM}()}
}
\concept{functions to extract from a GPPM}
