% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{Steel}
\alias{Steel}
\title{Hardened Steel}
\format{
A data frame with 40 rows and 2 variables:
\describe{
  \item{stress}{a numeric vector indicating the values of contact stress, in pounds per square inch x \eqn{10^{-6}}.}
  \item{life}{a numeric vector indicating the length of the time until the specimen of the hardened steel failed.}
}
}
\usage{
data(Steel)
}
\description{
This dataset consists of failure times for hardened steel
 specimens in a rolling contact fatigue test. Ten independent
 observations were taken at each of the four contact stress values.
 Response is the time that each specimen of hardened steel failed.
}
\examples{
dev.new()
data(Steel)
with(Steel,plot(log(stress), log(life), pch=16, xlab="Log(Stress)", ylab="log(Life)"))
}
\references{
McCool J. (1980) Confidence limits for Weibull regression with censored data. \emph{ Transactions on Reliability} 29:145-150.
}
\keyword{datasets}
