% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-ideogram.R
\name{plot_ideogram}
\alias{plot_ideogram}
\title{Add an aligned cytoband ideogram plot}
\usage{
plot_ideogram(
  mapping = aes(),
  ...,
  seqnames = NULL,
  size = NULL,
  active = NULL
)
}
\arguments{
\item{mapping}{Default list of aesthetic mappings to use for plot.
If not specified, must be supplied in each layer added to the plot.}

\item{...}{
  Arguments passed on to \code{\link[ggplot2:geom_text]{ggplot2::geom_text}}
  \describe{
    \item{\code{stat}}{The statistical transformation to use on the data for this layer.
When using a \verb{geom_*()} function to construct a layer, the \code{stat}
argument can be used to override the default coupling between geoms and
stats. The \code{stat} argument accepts the following:
\itemize{
\item A \code{Stat} ggproto subclass, for example \code{StatCount}.
\item A string naming the stat. To give the stat as a string, strip the
function name of the \code{stat_} prefix. For example, to use \code{stat_count()},
give the stat as \code{"count"}.
\item For more information and other ways to specify the stat, see the
\link[ggplot2:layer_stats]{layer stat} documentation.
}}
    \item{\code{position}}{A position adjustment to use on the data for this layer. This
can be used in various ways, including to prevent overplotting and
improving the display. The \code{position} argument accepts the following:
\itemize{
\item The result of calling a position function, such as \code{position_jitter()}.
This method allows for passing extra arguments to the position.
\item A string naming the position adjustment. To give the position as a
string, strip the function name of the \code{position_} prefix. For example,
to use \code{position_jitter()}, give the position as \code{"jitter"}.
\item For more information and other ways to specify the position, see the
\link[ggplot2:layer_positions]{layer position} documentation.
}}
    \item{\code{parse}}{If \code{TRUE}, the labels will be parsed into expressions and
displayed as described in \code{?plotmath}.}
    \item{\code{size.unit}}{How the \code{size} aesthetic is interpreted: as millimetres
(\code{"mm"}, default), points (\code{"pt"}), centimetres (\code{"cm"}), inches (\code{"in"}),
or picas (\code{"pc"}).}
    \item{\code{na.rm}}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}
    \item{\code{show.legend}}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display. To include legend keys for all levels, even
when no data exists, use \code{TRUE}.  If \code{NA}, all levels are shown in legend,
but unobserved levels are omitted.}
    \item{\code{inherit.aes}}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:annotation_borders]{annotation_borders()}}.}
    \item{\code{check_overlap}}{If \code{TRUE}, text that overlaps previous text in the
same layer will not be plotted. \code{check_overlap} happens at draw time and in
the order of the data. Therefore data should be arranged by the label
column before calling \code{geom_text()}. Note that this argument is not
supported by \code{geom_label()}.}
  }}

\item{seqnames}{A single logical or numeric value controlling chromosome
label display. Defaults to \code{TRUE}.
\itemize{
\item \strong{Logical (\code{TRUE}/\code{FALSE})}:
\itemize{
\item \code{TRUE}: display labels at the default offset:
\itemize{
\item \code{1} above the ideogram (vertical layout)
\item \code{-1} below the ideogram (horizontal layout)
}
\item \code{FALSE}: do not display labels.
}
\item \strong{Numeric}: Specifies the vertical position of labels relative to the
ideogram’s y-axis:
\itemize{
\item Positive: above the ideogram (offset from the upper border)
\item Negative: below the ideogram (offset from the lower border)
\item \code{0}: centered.
}
}

Note: The cytoband vertical range spans from \code{0} to \code{1}.}

\item{size}{The relative size of the plot, can be specified as a
\code{\link[grid:unit]{unit()}}. Note that for \code{\link[=circle_layout]{circle_layout()}}, all size values
will be interpreted as relative sizes, as this layout type adjusts based on
the available space in the circular arrangement.}

\item{active}{A \code{\link[=active]{active()}} object that defines the context settings when
added to a layout.}
}
\description{
Creates a cytoband ideogram-typically representing chromosome banding
patterns-and aligns it within a genomic layout.

Cytoband features (\code{gieStain}) are mapped to fill colors following standard
cytogenetic conventions (e.g., gpos, gneg, acen, stalk). Optionally,
chromosome names can be displayed as labels.
}
