% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gd_optunidisc.R
\name{gd_optunidisc}
\alias{gd_optunidisc}
\title{optimal univariate discretization based on geodetector q-statistic}
\usage{
gd_optunidisc(
  formula,
  data,
  discnum = 3:8,
  discmethod = c("sd", "equal", "geometric", "quantile", "natural"),
  cores = 1,
  seed = 123456789,
  ...
)
}
\arguments{
\item{formula}{A formula.}

\item{data}{A \code{data.frame}, \code{tibble} or \code{sf} object of observation data.}

\item{discnum}{(optional) A vector of numbers of discretization. Default is \code{3:8}.}

\item{discmethod}{(optional) A vector of methods for discretization, default is using
\code{c("sd","equal","geometric","quantile","natural")} by invoking \code{sdsfun}.}

\item{cores}{(optional) Positive integer (default is 1). When cores are greater than 1, use
multi-core parallel computing.}

\item{seed}{(optional) Random seed number, default is \code{123456789}.}

\item{...}{(optional) Other arguments passed to \code{sdsfun::discretize_vector()}.}
}
\value{
A list.
\describe{
\item{\code{x}}{the name of the variable that needs to be discretized}
\item{\code{k}}{optimal discretization number}
\item{\code{method}}{optimal discretization method}
\item{\code{qstatistic}}{optimal q-statistic}
\item{\code{disc}}{optimal discretization results}
}
}
\description{
optimal univariate discretization based on geodetector q-statistic
}
\examples{
data('sim')
gd_optunidisc(y ~ xa + xb + xc,
              data = sim,
              discnum = 3:6)

}
\author{
Wenbo Lv \email{lyu.geosocial@gmail.com}
}
