% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_quarto.R
\name{write_quarto}
\alias{write_quarto}
\title{Create a New 'Quarto' Document}
\usage{
write_quarto(
  filename = "Untitled-1",
  path = here::here(),
  example = FALSE,
  .initialize_proj = FALSE
)
}
\arguments{
\item{filename}{Character string. The name of the file without the '.qmd' extension.
Only letters, numbers, hyphens, and underscores are allowed.}

\item{path}{Character string. Path to the project directory.}

\item{example}{Logical. If TRUE, creates a Quarto document with a default to 
position the brand logo and examples of within-document cross-referencing, links,
and references.}

\item{.initialize_proj}{Logical. TRUE only if starting a 
\code{froggeR::quarto_project()}.}
}
\value{
Invisibly returns NULL after creating the 'Quarto' document.
}
\description{
This function creates a new 'Quarto' document (.qmd file) with either a custom
or standard YAML header. When using a custom header, it integrates with 
`froggeR::settings()` for reusable metadata across documents.
}
\examples{
if (interactive()) {
  # Create a temporary directory for testing
  tmp_dir <- tempdir()
  
  # Write the Quarto & associated files for a custom YAML with reusable metadata
  write_quarto(path = tempdir(), filename = "analysis")
 
  # Write the Quarto file with a template requiring more DIY
  write_quarto(path = tempdir(), filename = "analysis_basic", example = FALSE)
  
  # Confirm the file was created (optional, for user confirmation)
  file.exists(file.path(tmp_dir, "analysis.qmd"))
  file.exists(file.path(tmp_dir, "analysis_basic.qmd"))
  
  # Clean up: Remove the created file
  unlink(list.files(tempdir(), full.names = TRUE), recursive = TRUE)
}

}
