% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{disfa}
\alias{disfa}
\title{Disjoint Factor Analysis}
\usage{
disfa(X, Q, Rndstart, verbose, maxiter, tol, constr, prep, print)
}
\arguments{
\item{X}{Units x variables numeric data matrix.}

\item{Q}{Number of factors.}

\item{Rndstart}{Number of runs to be performed (Defaults is 20).}

\item{verbose}{Outputs basic summary statistics for each run (1 = enabled; 0 = disabled, default option).}

\item{maxiter}{Maximum number of iterations allowed (if convergence is not yet reached. Default is 100).}

\item{tol}{Tolerance threshold (maximum difference between the values of the objective function of two consecutive iterations such that convergence is assumed. Default is 1e-6).}

\item{constr}{is a vector of length J = nr. of variables, pre-specifying to which cluster some of the variables must be assigned. Each component of the vector can assume integer values from 1 o Q (See example for more details), or 0 if no constraint on the variable is imposed (i.e., it will be assigned based on the plain algorithm).}

\item{prep}{Pre-processing of the data. 1 performs the z-score transform (default choice); 2 performs the min-max transform; 0 leaves the data un-pre-processed.}

\item{print}{Prints summary statistics of the performed method (1 = enabled; 0 = disabled, default option).}
}
\value{
returns a list of estimates and some descriptive quantities of the final results.

\item{V}{Variables x factors membership matrix (binary and row-stochastic). Each row is a dummy variable indicating to which cluster each variable has been assigned.}

\item{A}{Variables x components loading matrix.}

\item{Psi}{Specific variance of each observed variable, not accounted for by the common factors (matrix).}

\item{discrepancy}{Value of the objective function, to be minimized. Difference between the observed and estimated covariance matrices (scalar).}

\item{RMSEA}{Adjusted Root Mean Squared Error (scalar).}

\item{AIC}{Aikake Information Criterion (scalar).}

\item{BIC}{Bayesian Information Criterion (scalar).}

\item{GFI}{Goodness of Fit Index (scalar).}
}
\description{
Performs disjoint factor analysis, i.e., a Factor Analysis with a simple structure. In fact, each factor is defined by a disjoint subset of variables, resulting thus, in a simplified, easier to interpret loading matrix A and factors. Estimation is carried out via Maximum Likelihood.
}
\examples{
# Iris data 
# Loading the numeric variables of iris data
iris <- as.matrix(iris[,-5]) 

# No constraint on variables
out <- disfa(iris, Q = 2)

# Constraint: the first two variables must contribute to the same factor.
outc <- disfa(iris, Q = 2, constr = c(1,1,0,0))

}
\references{
Vichi M. (2017) "Disjoint factor analysis with cross-loadings" <doi:10.1007/s11634-016-0263-9>
}
\author{
Ionel Prunila, Maurizio Vichi
}
