% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot.quantiles}
\alias{plot.quantiles}
\title{Plot Quantiles}
\usage{
\method{plot}{quantiles}(
  x,
  ...,
  conds = NULL,
  dv = NULL,
  col = NULL,
  xlim = NULL,
  ylim = c(0, 1),
  xlab = "RT [s]",
  ylab = "F(RT)",
  pch = 21,
  lty = 1,
  type = "l",
  legend = NULL,
  legend_pos = "bottomright"
)
}
\arguments{
\item{x}{a \link{data.frame}, containing quantiles, typically resulting from a
call to \link{calc_stats}.}

\item{...}{additional arguments passed to the \link{plot}, \link[graphics:points]{graphics::points},
and \link[graphics:legend]{graphics::legend} functions. Oftentimes, this will (unfortunately) lead
to an error due to a clash of arguments.}

\item{conds}{character vector, specifying the conditions to plot. Defaults to
all unique conditions.}

\item{dv}{character, specifying the quantiles to plot. Defaults to
quantiles derived from the upper boundary.}

\item{col}{character vector, specifying colors for each condition. If a
single color is provided, it will be repeated for each condition.}

\item{xlim, ylim}{numeric vectors of length 2, specifying the x and y axis
limits.}

\item{xlab, ylab}{character, labels for the x and y axes.}

\item{pch}{integer, specifying the plotting symbol for observed data points.}

\item{lty}{integer, line type for the predicted quantiles.}

\item{type}{character, type of plot for the predicted quantiles.}

\item{legend}{character vector, specifying legend labels corresponding to
the conditions in the quantiles. Defaults to the condition names.}

\item{legend_pos}{character, specifying the position of the legend on the
plot.}
}
\value{
Nothing (\code{NULL}; invisibly)
}
\description{
This function generates a plot of quantiles. It can display observed and
predicted values, making it useful for assessing model fit or exploring
observed data distributions.

If the data contains multiple IDs, quantiles are aggregated across IDs
before plotting.
}
\details{
The \code{plot.quantiles} function allows for a quick investigation of quantiles,
including options for color, symbols, and line types for different data
sources (observed vs. predicted). When the supplied \link{data.frame} includes
multiple IDs, quantiles are aggregated across IDs before plotting.
}
\examples{
# Example 1: Only model predictions ---------------------------------------
# get a quantiles data.frame for demonstration purpose
a_model <- dmc_dm(t_max = 1.5, dt = .0025, dx = .0025)
quantiles <- calc_stats(a_model, type = "quantiles")

# call the plot function with default values
plot(quantiles)

# make the plot a little bit more pretty
plot(quantiles,
  col = c("green", "red"),
  xlim = c(0.2, 0.6),
  ylab = "Quantile Level",
  xlab = "Response Times [s]"
)

# Example 2: Model predictions and observed data --------------------------
obs_data(a_model) <- dmc_synth_data
quantiles <- calc_stats(a_model, type = "quantiles")
plot(quantiles)
# Note: The model was not fitted to the data set, thus observed data and
# model predictions don't match


# Example 3: Only observed data -------------------------------------------
quantiles <- calc_stats(dmc_synth_data, type = "quantiles")
plot(quantiles)

}
