% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_controlType.R
\name{f.controlType}
\alias{f.controlType}
\title{Calculate type of control data collected in a study}
\usage{
f.controlType(df = NULL)
}
\arguments{
\item{df}{data frame such as from \link{dbGetFieldsIntoDf}. If `NULL`,
prints fields needed in `df` for calculating this trial concept, which can
be used with \link{dbGetFieldsIntoDf}.}
}
\value{
data frame with columns `_id` and `.controlType`, which is
a factor with levels `none`, `no-treatment`, `placebo`, `active`,
`placebo+active` and `other`.
}
\description{
Trial concept calculated: type of internal control.
ICH E10 lists as types of control: placebo concurrent control, no-treatment
concurrent control, dose-response concurrent control, active (positive)
concurrent control, external (including historical) control, multiple control
groups. Dose-controlled trials are currently not identified.
External (including historical) controls are so far not identified in specific
register fields. Cross-over designs, where identifiable, have active controls.
}
\examples{
# fields needed
f.controlType()

# apply trial concept when creating data frame
dbc <- nodbi::src_sqlite(
  dbname = system.file("extdata", "demo.sqlite", package = "ctrdata"),
  collection = "my_trials", flags = RSQLite::SQLITE_RO)
trialsDf <- dbGetFieldsIntoDf(
  field = "ctrname",
  calculate = "f.controlType",
  con = dbc)
trialsDf

}
