% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slides.R
\name{slideMarkdown}
\alias{slideMarkdown}
\alias{slideMarkdown<-}
\alias{newMarkdownSlide}
\alias{markdownSlideImage}
\alias{slideMarkdown,CrunchMarkdownSlide-method}
\alias{slideMarkdown<-,CrunchMarkdownSlide,character-method}
\title{Add a new markdown slide to a deck}
\usage{
slideMarkdown(x)

slideMarkdown(x) <- value

newMarkdownSlide(deck, ..., title = "", subtitle = "")

markdownSlideImage(file)

\S4method{slideMarkdown}{CrunchMarkdownSlide}(x)

\S4method{slideMarkdown}{CrunchMarkdownSlide,character}(x) <- value
}
\arguments{
\item{x}{A \code{CrunchMarkdownSlide}}

\item{value}{A string to replace the markdown content with}

\item{deck}{A Crunch Deck}

\item{...}{Unnamed arguments are text that are combined to create the markdown body
named arguments are passed to the API.}

\item{title}{The slide's title}

\item{subtitle}{The slide's subtitle}

\item{file}{File path to an image}
}
\value{
A \code{MarkdownCrunchSlide}
}
\description{
Markdown slides allow you to add rich text tiles to your Crunch Dashboards.
\code{markdownSlideImage()} is a helper for embedding the data of an image from
your computer into the slide.
}
\examples{
\dontrun{
newMarkdownSlide(deck, "We contacted 1,000 people by telephone", title = "Methodology")

newMarkdownSlide(
    deck,
    "The 3 most **popular** vegetables are:\n",
    "- Fennel\n",
    "- Carrots\n",
    "- Avocado\n",
    title = "Key findings"
)

newMarkdownSlide(
    deck,
    "crunch.io: ",
    markdownSlideImage("logo.png")
)
}
}
\seealso{
\code{\link[=newSlide]{newSlide()}} for creating an analysis slide
}
