% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/soil_phylum_small.R
\docType{data}
\name{soil_phylum_small}
\alias{soil_phylum_small}
\title{Small soil phylum data for examples}
\format{
A phyloseq-class experiment-level object with an OTU table and sample data.
\describe{
\item{otu_table}{OTU table with 7,770 taxa and 119 samples}
\item{tax_table}{taxonomy table}
\item{sam_data}{sample data with the following covariates:
\itemize{
\item \code{Plants}, values \code{0} and \code{1}. Index for different plants
\item \code{Day}, values \code{0} (initial sampling point), \code{1} (12 days after treatment additions), and \code{2} (82 days after treatment additions). Index for different days of measurement
\item \code{Amdmt}, values \code{0} (no additions), \code{1} (biochar additions), and \code{2} (fresh biomass additions). Index for different soil additives.
\item \code{DayAmdmt}, values \code{00}, \code{01}, \code{02}, \code{10}, \code{11}, \code{12}, \code{20}, \code{21}, and \code{22}. A single index for the combination of \code{Day} and \code{Amdmt} with \code{Day} as the first digit and \code{Amdmt} as the second digit.
\item \code{ID}, values \code{A}, \code{B}, \code{C}, \code{D},  and \code{F}. Index for different soil plots.
}}
}
}
\usage{
soil_phylum_small
}
\description{
A small subset of \code{\link{soil_phylo}} used for examples. A phyloseq object with an OTU table and sample data from a soil microbiome study.
}
\references{
Whitman, T., Pepe-Ranney, C., Enders, A., Koechli, C., Campbell, A.,  Buckley, D. H., Lehmann, J. (2016). \emph{Dynamics of microbial community composi-tion and soil organic carbon mineralization in soil following addition of pyrogenic andfresh organic matter}. The ISME journal, 10(12):2918. <doi: 10.1038/ismej.2016.68>.
}
\keyword{datasets}
