% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lrtest.R
\name{lrtest}
\alias{lrtest}
\title{Likelihood ratio test}
\usage{
lrtest(mod, mod_null)
}
\arguments{
\item{mod}{an object of class \code{bbdml}}

\item{mod_null}{an object of class \code{bbdml}, should be nested within \code{mod}}
}
\value{
P-value from likelihood ratio test.
}
\description{
Likelihood ratio test
}
\examples{
data(soil_phylum_small)
mod1 <- bbdml(formula = OTU.1 ~ DayAmdmt,
phi.formula = ~ DayAmdmt,
data = soil_phylum_small)

mod2 <- bbdml(formula = OTU.1 ~ 1,
phi.formula = ~ 1,
data = soil_phylum_small)
lrtest(mod1, mod2)
}
