\name{exHe}
\alias{exHe}
\non_function{}
\title{Small Dataset Example of He}
\usage{data(exHe)}
\description{
  The \code{exHe} data frame has 10 rows and 2 columns.  It is an
  example for which \code{\link{smooth.spline}} cannot be used.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{x}{only values 0, 1, and 2.}
    \item{y}{10 randomly generated values}
  }
}
\details{
  Xuming He wrote about this
  \bold{JUST FOR FUN:}\cr
  I was testing COBS using the following "data". For comparison, I tried
  smooth.spline in S+. I never got an answer back! No warning messages either.
  The point is that even the well-tested algorithm like
  \code{\link{smooth.spline}} could leave you puzzled.

  To tell you the truth, the response values here were generated by white
  noise.  An ideal fitted curve would be a flat line.  See for yourself what
  COBS would do in this case.
}
\source{
  Found at the bottom of \url{http://ux6.cso.uiuc.edu/~x-he/ftp.html},
  signed by \email{x-he@uiuc.edu}.
}
\seealso{
  \code{\link{cobs}}
}
\examples{
data(exHe)
plot(exHe, main = "He's 10 point example and cobs() fits")
tm <- tapply(exHe$y, exHe$x, mean)
lines(unique(exHe$x), tm, lty = 2)

cH. <- with(exHe,
    cobs(x, y, degree=1, constraint = "increase"))
cH <- with(exHe,
    cobs(x, y, lambda=0.2, degree=1, constraint = "increase"))
plot(exHe)
lines(predict(cH.), type = "o", col="tomato3", pch = "i")# constant
lines(predict(cH), type = "o", col=2, pch = "i")

cHn <- cobs(exHe$x, exHe$y, degree=1, constraint = "none")
lines(predict(cHn), col= 3, type = "o", pch = "n")

cHd <- cobs(exHe$x, exHe$y, degree=1, constraint = "decrease")
lines(predict(cHd), col= 4, type = "o", pch = "d")
}
\keyword{datasets}
