% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getquestion.R
\name{get_question}
\alias{get_question}
\title{Prints out the survey question column label for a given column in a given dataset.}
\usage{
get_question(do, q)
}
\arguments{
\item{do}{a CES survey data object (given as a character string)}

\item{q}{a column name in a CES survey data object (given as a character string)}
}
\value{
The associated question \code{q} in a loaded dataset \code{do}.
}
\description{
get_question() prints out the survey question associated with a given
column in a given dataset name.
}
\details{
The order of the parameters for \code{get_question} are data object then column name.
Both parameters must be character strings and cannot be reversed.
To return the associated survey question, the \code{get_question} function relies
on the \code{var_label} function from the \code{labelled} package.
}
\examples{
# print out CES code calls
get_cescodes()

# call CES survey
get_ces("ces1988")

# request the survey question for column a6
get_question("ces1988", "a6")

}
\seealso{
\code{get_ces()} function help.
\code{get_cescodes()} help.
}
