% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_mats.R
\name{create_mats}
\alias{create_mats}
\title{Create connection matrices for tractography or fMRI data}
\usage{
create_mats(A.files, modality = c("dti", "fmri"), divisor = c("none",
  "waytotal", "size", "rowSums"), div.files = NULL,
  threshold.by = c("consensus", "density", "mean", "consistency"),
  mat.thresh = 0, sub.thresh = 0.5, inds = list(1:length(A.files)),
  algo = c("probabilistic", "deterministic"), P = 5000, ...)
}
\arguments{
\item{A.files}{Character vector of the filenames with connection matrices}

\item{modality}{Character string indicating data modality (default:
\code{dti})}

\item{divisor}{Character string indicating how to normalize the connection
matrices; either 'none' (default), 'waytotal', 'size', or 'rowSums'
(ignored if \code{modality} equals \code{fmri})}

\item{div.files}{Character vector of the filenames with the data to
normalize by (e.g. a list of \emph{waytotal} files) (default: \code{NULL})}

\item{threshold.by}{Character string indicating how to threshold the data;
choose \code{density}, \code{mean}, or \code{consistency} if you want all
resulting matrices to have the same densities (default: \code{consensus})}

\item{mat.thresh}{Numeric (vector) for thresholding connection matrices
(default: 0)}

\item{sub.thresh}{Numeric (between 0 and 1) for thresholding by subject
numbers (default: 0.5)}

\item{inds}{List (length equal to number of groups) of integers; each list
element should be a vector of length equal to the group sizes}

\item{algo}{Character string of the tractography algorithm used (default:
\code{'probabilistic'}). Ignored if \emph{modality} is \code{fmri}.}

\item{P}{Integer; number of samples per seed voxel (default: 5000)}

\item{...}{Arguments passed to \code{\link{symmetrize_mats}}}
}
\value{
A list containing:
\item{A}{A 3-d array of the raw connection matrices}
\item{A.norm}{A 3-d array of the normalized connection matrices}
\item{A.bin}{A 3-d array of binarized connection matrices}
\item{A.bin.sums}{A list of 2-d arrays of connection matrices, with each
  entry signifying the number of subjects with a connection present; the
  number of list elements equals the length of \code{mat.thresh}}
\item{A.inds}{A list of arrays of binarized connection matrices, containing 1
  if that entry is to be included}
\item{A.norm.sub}{List of 3-d arrays of the normalized connection matrices
  for all given thresholds}
\item{A.norm.mean}{List of lists of numeric matrices averaged for each group}
}
\description{
\code{create_mats} will take a vector of filenames which contain connection
matrices (e.g. the \emph{fdt_network_matrix} files from FSL or the
\emph{ROICorrelation.txt} files from DPABI) and create arrays of this data.
You may choose to normalize these matrices by the \emph{waytotal} or
\emph{region size} (tractography), or not at all.
}
\details{
The argument \code{threshold.by} has 4 options:
\enumerate{
  \item \code{consensus} Threshold based on the raw (normalized, if selected)
    values in the matrices. If this is selected, it uses the
    \code{sub.thresh} value to perform "consensus" thresholding.
  \item \code{density} Threshold the matrices to yield a specific graph
    density (given by the \code{mat.thresh} argument).
  \item \code{mean} Keep only connections for which the cross-subject mean is
    at least 2 standard deviations higher than the threshold (specified by
    \code{mat.thresh})
  \item \code{consistency} Threshold based on the coefficient of variation to
    yield a graph with a specific density (given by \code{mat.thresh}). The
    edge weights will still represent those of the input matrices. See
    Roberts et al. (2017) for more on "consistency-based" thresholding.
}

The argument \code{mat.thresh} allows you to choose a numeric threshold,
below which the connections will be replaced with 0; this argument will also
accept a numeric vector. The argument \code{sub.thresh} will keep only those
connections for which at least \emph{X}\% of subjects have a positive entry
(the default is 0.5, or 50\%).
}
\examples{
\dontrun{
thresholds <- seq(from=0.001, to=0.01, by=0.001)
fmri.mats <- create_mats(f.A, modality='fmri', threshold.by='consensus',
  mat.thresh=thresholds, sub.thresh=0.5, inds=inds)
dti.mats <- create_mats(f.A, divisor='waytotal', div.files=f.way,
  mat.thresh=thresholds, sub.thresh=0.5, inds=inds)
}
}
\references{
Roberts JA, Perry A, Roberts G, Mitchell PB, Breakspear M (2017).
  \emph{Consistency-based thresholding of the human connectome.} NeuroImage,
  145:118-129.
}
\seealso{
Other Matrix functions: \code{\link{apply_thresholds}},
  \code{\link{cor.diff.test}},
  \code{\link{symmetrize_mats}}
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}
