% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_edges.R
\name{CountEdges}
\alias{CountEdges}
\alias{count_homologous}
\alias{count_interlobar}
\title{Count number of edges of a brain graph}
\usage{
count_homologous(g)

count_interlobar(g, lobe)
}
\arguments{
\item{g}{An \code{igraph} graph object}

\item{lobe}{A character string indicating the lobe to count from (uppercase)}
}
\value{
\code{count_homologous} - a named vector of the edge ID's connecting
  homologous regions

\code{count_interlobar} - a \code{data.table} of total, intra-, and
  inter-lobar edge counts
}
\description{
\code{count_homologous} counts the number of edges between homologous regions
in a brain graph (e.g. between L and R superior frontal).

\code{count_interlobar} counts the number of edges between all vertices in
one major lobe (e.g. Frontal) and all other major lobes.
}
\examples{
\dontrun{
g1.frontal <- count_interlobar(g[[1]][[N]], 'Frontal')
}
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}
