% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genXn_longitudinal.R
\name{gen_Xn_longitudinal}
\alias{gen_Xn_longitudinal}
\title{Design Matrix Generator in Longitudinal Setting}
\usage{
gen_Xn_longitudinal(ids, from, to, num_repeated_measures, poly_degree = 1)
}
\arguments{
\item{ids}{vector of unique subject ids, usually of length 2
for study design purposes.}

\item{from}{start time of repeated measures for
each subject}

\item{to}{end time of repeated measures for each
subject}

\item{num_repeated_measures}{desired length of the repeated measures
sequence. Should be a non-negative number, will be rounded up if fractional.}

\item{poly_degree}{degree of polynomial in longitudinal model, set to 1 by
default.}
}
\value{
Xn: a design matrix that can be used to assess the
Bayesian assurance through Monte Carlo sampling using
functions presented in this package.
}
\description{
Constructs design matrix using inputs that correspond
to a balanced longitudinal study design.
Used for power and sample size analysis in the Bayesian setting.
}
\examples{
## Example 1
## We pass in a vector of subject IDs and specify the start and end
## timepoints along with the desired length of the sequence.
## The resulting design matrix contains vectors of
## ones with lengths that correspond to the number of repeated
## measures for each unique subject.

ids <- c(1,2,3,4)
gen_Xn_longitudinal(ids, from = 1, to = 10, num_repeated_measures = 4)

## Example 2
## If we wish to fit a longitudinal model of a higher degree (e.g. 
## parabolic, cubic), we need to adjust the `poly_degree` variable

# parabolic
ids <- c(1,2,3,4)
gen_Xn_longitudinal(ids, from = 1, to = 10, num_repeated_measures = 4,
poly_degree = 2)

# cubic
ids <- c(1,2,3,4)
gen_Xn_longitudinal(ids, from = 1, to = 10, num_repeated_measures = 4,
poly_degree = 3)
}
\seealso{
\code{\link{gen_Xn}}
}
