% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nplcm-read-folder.R
\name{get_individual_prediction}
\alias{get_individual_prediction}
\title{get individual prediction (Bayesian posterior)}
\usage{
get_individual_prediction(x)
}
\arguments{
\item{x}{an \code{nplcm} object; it contains the file path \code{DIR_NPLCM}
to where the model results and specifications are stored. The function
first reads a list from this folder by \code{\link[=nplcm_read_folder]{nplcm_read_folder()}}}
}
\value{
a matrix of individual predictions; rows for cases, columns for causes
specified in \code{model_options$likelihood$cause_list}; See \code{\link[=nplcm]{nplcm()}}
}
\description{
must set \code{individual.pred = TRUE} in MCMC options (see the example of this
function)
}
\examples{
\donttest{
data(data_nplcm_noreg)
cause_list <- LETTERS[1:6]
J.BrS      <- 6
model_options_no_reg <- list(
  likelihood   = list(
    cause_list = cause_list,
    k_subclass = 2,
    Eti_formula = ~-1, # no covariate for the etiology regression
    FPR_formula = list(
      MBS1 =   ~-1)    # no covariate for the subclass weight regression
  ),
  use_measurements = c("BrS"), 
  # use bronze-standard data only for model estimation.
  prior= list(
    Eti_prior = overall_uniform(1,cause_list), 
    # Dirichlet(1,...,1) prior for the etiology.
    TPR_prior  = list(BrS = list(
      info  = "informative", # informative prior for TPRs
      input = "match_range", 
      # specify the informative prior for TPRs by specifying a plausible range.
      val = list(MBS1 = list(up =  list(rep(0.99,J.BrS)), 
                             # upper ranges: matched to 97.5\% quantile of a Beta prior
                             low = list(rep(0.55,J.BrS))))
      # lower ranges: matched to 2.5\% quantile of a Beta prior
    )
    )
  )
)     


set.seed(1)
# include stratification information in file name:
thedir    <- paste0(tempdir(),"_no_reg")

# create folders to store the model results 
dir.create(thedir, showWarnings = FALSE)
result_folder_no_reg <- file.path(thedir,paste("results",collapse="_"))
thedir <- result_folder_no_reg
dir.create(thedir, showWarnings = FALSE)

# options for MCMC chains:
mcmc_options_no_reg <- list(
  debugstatus = TRUE,
  n.chains = 1,
  n.itermcmc = as.integer(200), 
  n.burnin = as.integer(100), 
  n.thin = 1,
  individual.pred = TRUE, # <- must set to TRUE! 
  ppd = FALSE,
  result.folder = thedir,
  bugsmodel.dir = thedir
)

BrS_object_1 <- make_meas_object(patho = LETTERS[1:6], 
                                 specimen = "MBS", test = "1", 
                                 quality = "BrS", cause_list = cause_list)
clean_options <- list(BrS_objects = make_list(BrS_object_1))
# place the nplcm data and cleaning options into the results folder
dput(data_nplcm_noreg,file.path(thedir,"data_nplcm.txt")) 
dput(clean_options, file.path(thedir, "data_clean_options.txt"))

rjags::load.module("glm")

fitted_nplcm_noreg <- nplcm(data_nplcm_noreg,model_options_no_reg,mcmc_options_no_reg)
image(get_individual_prediction(fitted_nplcm_noreg))

}


}
