% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_st_constraints.R
\name{read_storages_constraints}
\alias{read_storages_constraints}
\title{Read Short-term storages / additional constraints}
\usage{
read_storages_constraints(opts = simOptions())
}
\arguments{
\item{opts}{list of simulation parameters returned by the function
\code{\link{setSimulationPath}}}
}
\value{
\code{list} with 2 sections per cluster/constraint (properties + values).
}
\description{
\ifelse{html}{\figure{badge_api_ok.svg}{options: alt='Antares API OK'}}{Antares API: \strong{OK}}
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

This function reads constraints of an Antares project (by area/cluster) :
\itemize{
\item Properties
\item Time series
}

\emph{Be aware that constraints are read in the input files of a study.
So they may have changed since a simulation has been run.}
}
\examples{
\dontrun{
# read/load an existing study (version >= 9.2)
setSimulationPath(path = "mypath/study")

read_storages_constraints()
}
}
