% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RunAdaptiveEFFTOX.R
\name{RunAdaptiveEFFTOX}
\alias{RunAdaptiveEFFTOX}
\title{Simulates replications from EFF-TOX phase 12 trial.}
\usage{
RunAdaptiveEFFTOX(NSims, Dose, PE, PT, corET, Nmax, cohort, NF, Contour,
  CutE, CutT, AcceptE, AcceptT, HypermeansEFF, HypervarsEFF)
}
\arguments{
\item{NSims}{Number of simulations.}

\item{Dose}{Log-standardized doses (log(Raw Dose)-mean(log(Raw Dose))).}

\item{PE}{True Efficacy Probability for each dose.}

\item{PT}{True toxicity probaiblity for each dose.}

\item{corET}{Correlation parameter between Efficacy and Toxicity status.}

\item{Nmax}{Maximum Sample size.}

\item{cohort}{Cohort Size.}

\item{NF}{Number of fixed assignment patients until adaptive randomization. If NF equals Nmax, the trial is conducted without adaptive randomization.}

\item{Contour}{Vector containing 4 entries used to make the desireability function. Contour(1) contains a desired toxicity probability given efficacy, Countour(2) contains a desired efficacy probability given toxicity, and (Contour(3),Contour(4)) is an equally desireable pair of efficacy and toxicity probabilities that are non zero or one.}

\item{CutE}{Cutoff for efficacy acceptability.}

\item{CutT}{Cutoff for toxicity acceptability.}

\item{AcceptE}{Probability threshold for efficacy acceptability.}

\item{AcceptT}{Probability threshold for toxicity acceptability.}

\item{HypermeansEFF}{Vector containing prior hypermeans of length 6 for EFF-TOX parameters}

\item{HypervarsEFF}{Vector containing prior hypervariances of length 6 for EFF-TOX parameters}
}
\value{
A list of size NSims with results from each simulated trial. Each entry contains a list with (1) the optimal dose selected, (2) the posterior mean utility for each dose level, (3) a matrix containing the dose given, the efficacy outcome and the toxicity outcome for each patient.
}
\description{
Simulates trial replications from the EFF-TOX phase 12 trial trial using either adaptive randomization or fixed dose assignment.   Prints the true utility scores, dose selection probability, 
average number of patients treated at each dose, average number of responses, average number of toxicities, and Delta value. Returns trial outcomes.
}
\examples{
##Trial PArameters here
Nmax=30 ##Number of patients to enroll
NF=30 ##Number until AR if NF=Nmax, there's no AR.
cohort=3
#' Raw Dose Values
Dose = c(1,2,3,3.5,5)
Dose=log(Dose)-mean(log(Dose))
## Contour Vector
Contour = c(.35, .75,.7,.4)
#Starting Dose
DoseStart=1
##Safety Parameters
CutE=.3
CutT=.4
AcceptE=.1
AcceptT=.1
##Hypermeans
HypermeansEFF = c(.022,3.45,0,-4.23,3.1,0)
##Hypervariances 
HypervarsEFF = c(2.6761, 2.6852, .2, 3.1304, 3.1165, 1)
HypervarsEFF=HypervarsEFF^2 
#True Efficacy and Toxicity probabilities
PE=c(.2,.4,.6,.7,.7)
PT=c(.2,.2,.2,.3,.5)
corET=0
##Number of simulations
NSims=2
RESULTS=RunAdaptiveEFFTOX(NSims,Dose,PE, PT, corET, Nmax, cohort, 
NF, Contour, CutE, CutT, AcceptE, AcceptT, HypermeansEFF, HypervarsEFF )
}
\references{
Thall, P.F. and Cook, J.D. (2004). Dose-finding based on efficacy-toxicity trade-offs. Biometrics 60, 684-693.

Chapple AG, Thall PF. A Hybrid Phase 123 Clinical Trial Design Allowing Dose Re-optimization in Phase III. Biometrics. Epub ahead of print 26 October 2018.
}
