% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Concordance.R
\name{ConcordantInformation}
\alias{ConcordantInformation}
\alias{Evaluate}
\alias{ConcordantInfo}
\title{Evaluate the concordance of information between a tree and a dataset}
\usage{
ConcordantInformation(tree, dataset)

Evaluate(tree, dataset)

ConcordantInfo(tree, dataset)
}
\arguments{
\item{tree}{A tree of class \code{\link{phylo}}.}

\item{dataset}{A phylogenetic data matrix of \pkg{phangorn} class
\code{phyDat}, whose names correspond to the labels of any accompanying tree.}
}
\value{
\code{ConcordantInformation()} returns a named vector with elements:
\itemize{
\item \code{informationContent}: cladistic information content of \code{dataset}
\item \code{signal}, \code{noise}: amount of cladistic information that represents
phylogenetic signal and noise, according to \code{tree}
\item \code{signalToNoise}: the implied signal:noise ratio of \code{dataset}
\item \code{treeInformation}: the cladistic information content of a bifurcating tree
on \code{dataset}; this is the minimum amount of information necessary to resolve
a bifurcating tree, assuming no duplicate information or noise
\item \code{matrixToTree}: the ratio of the cladistic information content of the
matrix to the cladistic information content of the tree, a measure of the
redundancy of the matrix
\item \code{ignored}: information content of characters whose signal and noise could
not be calculated (too many states) and so are not included in the totals
above.
}
}
\description{
Details the amount of information in a phylogenetic dataset that is
consistent with a specified phylogenetic tree, and the signal:noise
ratio of the character matrix implied if the tree is true.
}
\details{
Presently restricted to datasets whose characters contain a maximum of
two parsimony-informative states.
}
\examples{
data(congreveLamsdellMatrices)
myMatrix <- congreveLamsdellMatrices[[10]]
ConcordantInformation(TreeTools::NJTree(myMatrix), myMatrix)
}
\author{
\href{https://smithlabdurham.github.io/}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
