% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/objects.R
\name{Annotation}
\alias{Annotation}
\alias{Annotation<-}
\alias{Annotation.ChromatinAssay}
\alias{Annotation.Seurat}
\alias{Annotation<-.ChromatinAssay}
\alias{Annotation<-.Seurat}
\title{Annotation}
\usage{
Annotation(object, ...)

Annotation(object, ...) <- value

\method{Annotation}{ChromatinAssay}(object, ...)

\method{Annotation}{Seurat}(object, ...)

\method{Annotation}{ChromatinAssay}(object, ...) <- value

\method{Annotation}{Seurat}(object, ...) <- value
}
\arguments{
\item{object}{A Seurat object or ChromatinAssay object}

\item{...}{Arguments passed to other methods}

\item{value}{A value to set. Can be NULL, to remove the current annotation
information, or a \code{\link[GenomicRanges]{GRanges}} object. If a
\code{GRanges} object is supplied and the genome information is stored in the
assay, the genome of the new annotations must match the genome of the assay.}
}
\value{
Returns a \code{\link[GenomicRanges]{GRanges}} object
if the annotation data is present, otherwise returns NULL
}
\description{
Get the annotation from a ChromatinAssay
}
\examples{
\donttest{
Annotation(atac_small[["peaks"]])
}
\donttest{
Annotation(atac_small)
}
genes <- Annotation(atac_small)
Annotation(atac_small[["peaks"]]) <- genes
genes <- Annotation(atac_small)
Annotation(atac_small) <- genes
}
\concept{assay}
