% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SEMhelp.R
\name{crossValidation}
\alias{crossValidation}
\title{Cross-validation of linear SEM, ML or DNN training models}
\usage{
crossValidation(
  models,
  outcome = NULL,
  K = 5,
  R = 1,
  metric = NULL,
  ncores = 2,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{models}{A named list of model fitting objects from \code{SEMrun()},
\code{SEMml()} or \code{SEMdnn()} function, with default group=NULL (for
\code{SEMrun()} or outcome=NULL (for \code{SEMml()} or \code{SEMdnn()}).}

\item{outcome}{A character vector (as.factor) of labels for a categorical
output (target). If NULL (default), the categorical output (target) will
not be considered.}

\item{K}{A numerical value indicating the number of k-fold to create.}

\item{R}{A numerical value indicating the number of repetitions for the k-fold
cross-validation.}

\item{metric}{A character value indicating the metric for boxplots display, i.e.:
"amse", "r2", or "srmr", for continuous outcomes, and "f1", "accuracy" or "mcc",
for a categorical outcome (default = NULL).}

\item{ncores}{Number of cpu cores (default = 2).}

\item{verbose}{Output to console boxplots and summarized results (default = FALSE).}

\item{...}{Currently ignored.}
}
\value{
A list of 2 objects: (1) "stats", a list with performance evaluation metrics.
If \code{outcome=FALSE}, mean and (0.025;0.0975)-quantiles of amse, r2, and srmr
across folds and repetitions are reported; if \code{outcome=TRUE}, mean and
(0.025;0.0975)-quantiles of f1, accuracy and mcc from confusion matrix averaged across
all repetitions are reported; and (2) "PE", a data.frame of repeated cross-validation
results.
}
\description{
The function does a R-repeated K-fold cross-validation
of \code{SEMrun()}, \code{SEMml()} or \code{SEMdnn()} models.
}
\details{
Easy-to-use model comparison and selection of SEM, ML or DNN models,
in which several models are defined and compared in a R-repeated K-fold
cross-validation procedure. The winner model is selected by reporting the mean
predicted performances across all runs, as outline in de Rooij & Weeda (2020).
}
\examples{

\donttest{
# Load Amyotrophic Lateral Sclerosis (ALS)
ig<- alsData$graph
data<- alsData$exprs
data<- transformData(data)$data
group<- alsData$group

# ... with continuous outcomes 

res1 <- SEMml(ig, data, algo="tree")
res2 <- SEMml(ig, data, algo="rf")
res3 <- SEMml(ig, data, algo="xgb")
res4 <- SEMml(ig, data, algo="nn")

models <- list(res1,res2,res3,res4)
names(models) <- c("tree","rf","xgb","nn")

res.cv1 <- crossValidation(models, outcome=NULL, K=5, R=10)
print(res.cv1$stats)

#... with a categorical (as.factor) outcome

outcome <- factor(ifelse(group == 0, "control", "case"))
res.cv2 <- crossValidation(models, outcome=outcome, K=5, R=10)
print(res.cv2$stats)
}

}
\references{
de Rooij M, Weeda W. Cross-Validation: A Method Every Psychologist Should Know.
Advances in Methods and Practices in Psychological Science. 2020;3(2):248-263.
doi:10.1177/2515245919898466
}
\author{
Mario Grassi \email{mario.grassi@unipv.it}
}
