% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HCRs.R
\name{TAC_MSY}
\alias{TAC_MSY}
\alias{calculate_TAC}
\title{Calculate MSY-based TAC from Assessment object}
\usage{
TAC_MSY(Assessment, reps, MSY_frac = 1)
}
\arguments{
\item{Assessment}{An Assessment object with estimates of UMSY or FMSY and
terminal year vulnerable biomass.}

\item{reps}{The number of stochastic draws of UMSY or FMSY.}

\item{MSY_frac}{The fraction of FMSY or UMSY for calculating the TAC (e.g. MSY_frac = 0.75 fishes at 75\% of FMSY).}
}
\value{
A vector of length \code{reps} of stochastic samples of TAC recommendation. Returns NA's
if missing either UMSY/FMSY or vulnerable biomass.
}
\description{
A function to calculate the total allowable catch (TAC). Based on the MSY (maximum
sustainable yield) principle, the TAC is the product of
either UMSY or FMSY and the available biomass, i.e. vulnerable biomass, in terminal year.
}
\note{
\code{calculate_TAC} is deprecated as of version 1.2 in favor of \code{TAC_MSY} because
the latter has a more informative name.
}
\seealso{
\link{HCR_MSY} \link{HCR40_10} \link{HCR60_20}
}
