% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrap06rotation.R
\name{wrap.rotation}
\alias{wrap.rotation}
\title{Prepare Data on Rotation Group}
\usage{
wrap.rotation(input)
}
\arguments{
\item{input}{data matrices to be wrapped as \code{riemdata} class. Following inputs are considered,
\describe{
\item{array}{a \eqn{(p\times p\times n)} array where each slice along 3rd dimension is a rotation matrix.}
\item{list}{a length-\eqn{n} list whose elements are \eqn{(p\times p)} rotation matrices.}
}}
}
\value{
a named \code{riemdata} S3 object containing
\describe{
  \item{data}{a list of \eqn{(p\times p)} rotation matrices.}
  \item{size}{size of each rotation matrix.}
  \item{name}{name of the manifold of interests, \emph{"rotation"}}
}
}
\description{
Rotation group, also known as special orthogonal group, is a Riemannian 
manifold
\deqn{SO(p) = \lbrace Q \in \mathbf{R}^{p\times p}~\vert~ Q^\top Q = I, \textrm{det}(Q)=1 \rbrace }
where the name originates from an observation that when \eqn{p=2,3} these matrices are rotation of 
shapes/configurations.
}
\examples{
#-------------------------------------------------------------------
#                 Checker for Two Types of Inputs
#-------------------------------------------------------------------
## DATA GENERATION
d1 = array(0,c(3,3,5))
d2 = list()
for (i in 1:5){
  single  = qr.Q(qr(matrix(rnorm(9),nrow=3)))
  d1[,,i] = single
  d2[[i]] = single
}

## RUN
test1 = wrap.rotation(d1)
test2 = wrap.rotation(d2)

}
\concept{wrapper}
