% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crit.R
\name{AIC.remix}
\alias{AIC.remix}
\title{AIC for remix object}
\usage{
\method{AIC}{remix}(object, ..., k)
}
\arguments{
\item{object}{output of \code{\link{remix}}.}

\item{...}{additional arguments.}

\item{k}{numeric, the penalty per parameter to be used; the default k = 2 is the classical AIC.}
}
\value{
AIC.
}
\description{
Computes akaike information criterion from the output of \code{\link{remix}} as
\deqn{AIC = -2\mathcal{LL}_{y}(\hat\theta,\hat\alpha)+k\times P}
where \eqn{P} is the total number of parameters estimated and \eqn{\mathcal{LL}_{y}(\hat\theta,\hat\alpha)} the log-likelihood of the model.
}
\examples{
\dontrun{
project <- getMLXdir()

ObsModel.transfo = list(S=list(AB=log10),
                        linkS="yAB",
                        R=rep(list(S=function(x){x}),5),
                        linkR = paste0("yG",1:5))

alpha=list(alpha0=NULL,
           alpha1=setNames(paste0("alpha_1",1:5),paste0("yG",1:5)))

y = c(S=5,AB=1000)
lambda = 1440

res = remix(project = project,
            dynFUN = dynFUN_demo,
            y = y,
            ObsModel.transfo = ObsModel.transfo,
            alpha = alpha,
            selfInit = TRUE,
            eps1=10**(-2),
            eps2=1,
            lambda=lambda)

AIC(res)
}
}
\references{
Akaike, H. 1998. Information theory and an extension of the maximum likelihood principle, Selected papers of hirotugu akaike, 199-213. New York: Springer.
}
