% Generated by roxygen2 (4.0.2): do not edit by hand
\name{coef.qualint}
\alias{coef.qualint}
\title{Extract estimation results from a "qualint" object}
\usage{
\method{coef}{qualint}(object, ...)
}
\arguments{
\item{object}{a qualint object}

\item{...}{not used. Additional print arguments}
}
\value{
A numeric matrix (see above). For \code{type = "continuous"},
it is the estimation results for mean difference. For \code{type = "binary"},
it is for risk difference, log relative risk or log odds ration. For
\code{type = "survival"}, it is for log hazard ratio.
}
\description{
Similar to other coef methods, this function
extracts the estimation results from an "qualint" object.
}
\details{
This function extracts the results related with estimating results of the
interaction test from a "qualint" object. It returns a matrix which contains
the estimating results of the treatment effects which will used directly in
the testing process later. FOr continuous responses, it is the
mean difference. For binary responses, it is the risk difference, log relative
risk or log odds ratio. For survival responses, it it the log hazard ratio.
}
\examples{
ynorm <- rnorm(300)
trtment <- sample(c(0, 1), 300, prob = c(0.4, 0.6),
                  replace = TRUE)
subgrp <- sample(c(0, 1, 2), 300, prob = c(1/3, 1/3, 1/3),
                 replace = TRUE)
test1 <- qualint(ynorm, trtment, subgrp)
coef(test1)
}
\author{
Lixi Yu, Eun-Young Suh, Guohua (James) Pan \cr
Maintainer: Lixi Yu \email{lixi-yu@uiowa.edu}
}
\references{
Gail and Simon (1985), Testing for qualitative interactions between
treatment effects and patient subsets, Biometrics, 41, 361-372.

Pan and Wolfe (1993), Tests for generalized problems of detecting
qualitative interaction, Technical Report No. 526, Department of Statistics,
The Ohio State University.

Pan and Wolfe (1997), Test for qualitative interaction of clinical
significance, Statistics in Medicine, 16, 1645-1652.
}
\seealso{
\code{\link{print.qualint}}, \code{\link{plot.qualint}}
}

