% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{windowedFrequencyShift.plotter}
\alias{windowedFrequencyShift.plotter}
\title{Data displayer}
\usage{
windowedFrequencyShift.plotter(
  windowed_shift,
  selected_parent = "sim",
  backcrossed_parent = "sec",
  contigs = c("chr2L", "chr2R", "chr3L", "chr3R"),
  main_title = "popPsiSeq results",
  ref_gen = "droSim1",
  primary_aesthetic = ggplot2::aes(),
  envelope_aesthetic = ggplot2::aes(),
  ancestral_aesthetic = ggplot2::aes()
)
}
\arguments{
\item{windowed_shift}{GRanges containing windowed data (as loaded by import.smvshft)}

\item{selected_parent}{Name of the selected-for population}

\item{backcrossed_parent}{Name of the backcrossed-too population}

\item{contigs}{What contigs to display}

\item{main_title}{What to call the plot}

\item{ref_gen}{Name of the reference genome}

\item{primary_aesthetic}{Primary aesthetic}

\item{envelope_aesthetic}{envelope aesthetic}

\item{ancestral_aesthetic}{ancestral aesthetic}
}
\value{
a ggbio plot object
}
\description{
Data displayer
}
\examples{
\donttest{
windowed_shifts.filename <- system.file("extdata",
"windowed_shifts.example_data.bed", package = "PopPsiSeqR")
windowed_shifts.bg <- import.smvshift(windowed_shifts.filename)
windowedFrequencyShift.plotter(windowed_shifts.bg)
}
}
